/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

#ifndef _MIRA_PERFSTATS_H_
#define _MIRA_PERFSTATS_H_

#include <fstream>
#include <string>
#include <sstream>

inline uint64_t getCycleCount()
{
	uint64_t cycles;
#ifdef _MSC_VER // Microsoft Visual C++
# ifdef _WIN64
	cycles = __rdtsc();
# else
	__asm {
		rdtsc
		mov DWORD PTR[cycles]  , eax
		mov DWORD PTR[cycles+4], edx
	}
# endif
#else // GCC
	asm volatile ("rdtsc" : "=A" (cycles));
#endif
	return cycles;
}


inline uint64_t getMemoryUsage()
{
#ifdef _MSC_VER // Microsoft Visual C++
	// TODO: not implemented for MSVC++
	return 0;
#else
	using std::ios_base;
	using std::ifstream;
	using std::string;

	ifstream statStream("/proc/self/status", ios_base::in);
	string line;
	while(!std::getline(statStream, line).eof())
	{
		if (line.find("VmSize") != std::string::npos)
		{
			std::stringstream ss(line);
			string name;
			uint64_t mem;
			ss >> name >> mem;
			return mem;
		}
	}
	return 0;
#endif
}


#endif
