/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file PolymorphicClasses.h
 *
 * @author Erik Einhorn
 */
#ifndef _MIRA_POLYMORPHICCLASSES_H_
#define _MIRA_POLYMORPHICCLASSES_H_

#include <serialization/Serialization.h>

using namespace std;
using namespace mira;

class BaseClass : public mira::Object
{
MIRA_OBJECT(BaseClass)
public:

	BaseClass() : i(0) {}
	BaseClass(bool) : i(12345) {}

	virtual void check() {
		BOOST_CHECK_EQUAL(i, 12345);
	}

	virtual bool isDerived() {return false;}

	template<typename Reflector>
	void reflect(Reflector& r)
	{
		r.member("i", i, "");
	}


public:

	int i;
};
MIRA_CLASS_SERIALIZATION(BaseClass, mira::Object);


class DerivedClass : public BaseClass
{
MIRA_OBJECT(DerivedClass)
public:

	DerivedClass() : j(0) {}
	DerivedClass(bool) : BaseClass(true), j(54321) {}

	virtual void check() {
		BaseClass::check();
		BOOST_CHECK_EQUAL(j, 54321);
	}

	virtual bool isDerived() {return true;}


	template<typename Reflector>
	void reflect(Reflector& r)
	{
		BaseClass::reflect(r);
		r.member("j", j, "");
	}


	int j;
};
MIRA_CLASS_SERIALIZATION(DerivedClass, BaseClass);


class ClassWithPolymorphicMember
{
public:

	ClassWithPolymorphicMember() : object(NULL), object2(NULL) {}
	ClassWithPolymorphicMember(bool)
	{
		object = new DerivedClass(true);
		object2 = object;
		objects.push_back(new BaseClass(true));
		objects.push_back(new DerivedClass(true));
		objects.push_back(new BaseClass(true));
	}

	~ClassWithPolymorphicMember()
	{
		delete object;
		foreach(BaseClass* obj, objects)
			delete obj;
	}


	void check() {
		BOOST_REQUIRE(object!=NULL);
		// check if we have the correct derived object
		BOOST_CHECK_EQUAL(object->isDerived(), true);

		// check the object itself
		object->check();

		// check if reference was serialized correctly
		BOOST_CHECK_EQUAL(object, object2);

		BOOST_REQUIRE_EQUAL(objects.size(),3);

		for(size_t i=0; i<objects.size(); ++i)
		{
			BOOST_REQUIRE(objects[i]!=NULL);
			objects[i]->check();
		}

		BOOST_CHECK_EQUAL(objects[0]->isDerived(), false);
		BOOST_CHECK_EQUAL(objects[1]->isDerived(), true);
		BOOST_CHECK_EQUAL(objects[2]->isDerived(), false);
	}


	template<typename Reflector>
	void reflect(Reflector& r)
	{
		r.member("object", object, "");
		r.member("object2", object2, "");
		r.member("objects", objects, "");
	}

private:

	BaseClass* object;
	BaseClass* object2;
	vector<BaseClass*> objects;
};

#endif
