/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file tuple.hpp
 *    non-intrusive reflection for boost::tuple
 *
 * @author Erik Einhorn
 * @date   2011/10/16
 */

#ifndef _MIRA_TUPLE_HPP_
#define _MIRA_TUPLE_HPP_

#ifndef Q_MOC_RUN
#include <boost/tuple/tuple.hpp>
#endif

#include <platform/Types.h>
#include <serialization/IsCollection.h>
#include <serialization/ReflectorInterface.h>
#include <serialization/ReflectCollectionCount.h>

namespace mira {

//////////////////////////////////////////////////////////////////////////////

namespace serialization { // our private namespace

template <typename Reflector,typename Tuple>
class TupleReflectHelper
{
public:

	template <typename HT, typename TT>
	TupleReflectHelper(Reflector& r, boost::tuples::cons<HT,TT>& t) :
		mR(r), mIndex(0)
	{
		invoke(t);
	}

	// special handling for empty tuple
	TupleReflectHelper(Reflector& r, boost::tuple<>& empty) : mR(r), mIndex(0)
	{
	}

private:

	template <typename HT>
	void invoke(boost::tuples::cons<HT,boost::tuples::null_type>& t)
	{
		std::string tmpName = "item"+toString(mIndex);
		MIRA_PROPERTY_WITH_ID(mR, tmpName.c_str(), tmpName, t.head, "");
		++mIndex;
	}

	template <typename HT, typename TT>
	void invoke(boost::tuples::cons<HT,TT>& t)
	{
		std::string tmpName = "item"+toString(mIndex);
		MIRA_PROPERTY_WITH_ID(mR, tmpName.c_str(), tmpName, t.head, "");
		++mIndex;
		// continue with rest
		invoke(t.get_tail());
	}

private:
	Reflector& mR;
	uint32 mIndex;
};

} // namespace

///////////////////////////////////////////////////////////////////////////////

/// non-intrusive reflect for boost::tuple
template <typename Reflector,
          class T0, class T1, class T2, class T3, class T4,
          class T5, class T6, class T7, class T8, class T9>
void reflect(Reflector& r, boost::tuple<T0,T1,T2,T3,T4,T5,T6,T7,T8,T9>& t)
{
	typedef boost::tuple<T0,T1,T2,T3,T4,T5,T6,T7,T8,T9> Tuple;
	serialization::TupleReflectHelper<Reflector, Tuple> h(r,t);
}

///////////////////////////////////////////////////////////////////////////////

} // namespace

#endif
