/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

#include <math.h>

#include <serialization/Serialization.h>

using namespace mira;
using namespace std;

class MyAbstractClass
{
public:
	virtual ~MyAbstractClass() {}
	virtual void method() = 0;

	template<typename Reflector>
	void reflect(Reflector& r)
	{
	}

};

class MyNormalPolymorphicClass : public MyAbstractClass
{
public:
	MyNormalPolymorphicClass()
	{
		cout << "I am MyNormalPolymorphicClass" << endl;
	}

	virtual ~MyNormalPolymorphicClass() {}
	virtual void method() {
		// do something
	}

	template<typename Reflector>
	void reflect(Reflector& r)
	{
	}

};

class MyAbstractObject : public Object
{
MIRA_OBJECT( MyAbstractObject )
public:

	MyAbstractObject()
	{
		cout << "I am MyAbstractObject" << endl;
		a=3;
	}

	virtual void method() = 0;

	template<typename Reflector>
	void reflect(Reflector& r)
	{
		r.member("a",a, "", 5);
	}

	int a;
};

class MyObject : public MyAbstractObject
{
MIRA_OBJECT( MyObject )
public:

	MyObject()
	{
		cout << "I am MyObject" << endl;
		b=4;
	}

	virtual void method() {};

	template<typename Reflector>
	void reflect(Reflector& r)
	{
		MyAbstractObject::reflect(r);
		r.member("b",b, "", 10);
	}

	int b;
};

class MyDerivedObject : public MyObject
{
MIRA_OBJECT( MyDerivedObject )
public:

	MyDerivedObject()
	{
		cout << "I am MyDerivedObject" << endl;
		a=5;
		b=12;
		c=44;
	}



	template<typename Reflector>
	void reflect(Reflector& r)
	{
		MyObject::reflect(r);
		r.member("c",c, "");
	}

	int c;
};


MIRA_CLASS_SERIALIZATION( MyAbstractObject, Object );
MIRA_CLASS_SERIALIZATION( MyObject, MyAbstractObject );
MIRA_CLASS_SERIALIZATION( MyDerivedObject, MyObject );


class MyClass
{

public:

	MyClass()
	{
		mIntPtr = new int(3);
		//mObj = new MyDerivedObject;
		mObj = NULL;
		mPolymorphic = NULL;
		mMyEnum = Value2;
	}

	template<typename Reflector>
	void reflect(Reflector& r)
	{
		// a normal member
		//r.member("intPtr", mIntPtr, "");
		r.member("obj", mObj, "");
		//r.member("abstract", mAbstract, "");
		r.member("polymorphic", mPolymorphic, "");
		r.member("myEnum", mMyEnum, "");
	}

private:

	enum MyEnum
	{
		Value1,
		Value2,
		Value3
	};

	MyEnum mMyEnum;


	int* mIntPtr;
	MyAbstractClass* mAbstract;

public:
	MyAbstractObject* mObj;
	MyNormalPolymorphicClass* mPolymorphic;

};


int main()
{
	XMLDom xml;
	XMLSerializer s(xml);

	MyClass c;
	c.mObj = new MyDerivedObject;
	//c.mObj = NULL;
	c.mPolymorphic = new MyNormalPolymorphicClass;

	s.serialize("test", c);

	xml.saveToFile("classfactory.xml");

	cout << "Loading" << endl;

	XMLDom xml2;
	xml2.loadFromFile("classfactory.xml");
	XMLDeserializer d(xml2.croot());
	MyClass c2;
	d.deserialize("test", c2);


	// print the class to the console using the TxtSerializer:
	cout << "Deserializer class is: " << endl;
	cout << print(c2) << endl;

	return 0;
}
