/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file IconProvider.h
 *    Simple class to provide package icons.
 *
 * @author Ronny Stricker
 * @date   2012/09/21
 */

#ifndef _MIRA_ICONPROVIDER_H_
#define _MIRA_ICONPROVIDER_H_

#include <QtGui/QPixmap>
#include <QtGui/QIcon>

#include <utils/Singleton.h>

#include <core/PackageGroup.h>
#include <core/Dependency.h>
#include <core/Database.h>

namespace mira {

///////////////////////////////////////////////////////////////////////////////

/**
 * @brief simple icon provider class.
 */
class IconProvider : public LazySingleton<IconProvider>
{

public:
	IconProvider();

	/**
	 * @brief Return icon for the given combination of package and dependency type.
	 */
	QIcon const& getIcon( bool installed, PackageGroup::Type const& baseType,
			Dependency::DependencyFlags const& depFlags ) const;

	/**
	 * @brief Return icon for the given database action
	 */
	QPixmap const& getIcon( Database::Action const& action );

protected:
	QPixmap mAvailable;
	QPixmap mInstalled;

	QPixmap mInstall;
	QPixmap mUninstall;

	std::map<PackageGroup::Type,QPixmap> mutable mIconBase;
	std::map<Dependency::DependencyFlags,QPixmap> mutable mIconDepFlags;
	std::map< bool, std::map<uint32, QIcon > > mutable mIconCache;
};

///////////////////////////////////////////////////////////////////////////////

} // namespace

#endif
