/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file MIRAPackageApp.h
 *    TODO Add description.
 *
 * @author Ronny Stricker
 * @date   2011/21/10
 */

#ifndef _MIRA_MIRAPACKAGEAPP_H_
#define _MIRA_MIRAPACKAGEAPP_H_

#include <QApplication>
#include <QMessageBox>

#include <error/Exception.h>

#include <core/Tools.h>

namespace mira {

///////////////////////////////////////////////////////////////////////////////

/**
 * @brief Simple wrapper to enable exception handling
 */
class MIRAPackageApp : public QApplication {
	Q_OBJECT

public:
	MIRAPackageApp(  int& argc, char** argv  ) : QApplication( argc, argv ) {
		QAppExist::set( true );
	}
	virtual ~MIRAPackageApp() {}

	/**
	 * @brief Notify function to catch all exceptions.
	 */
	virtual bool notify( QObject* receiver, QEvent* e )
	{
		try {
			return QApplication::notify(receiver,e);
		}
		// try to catch MIRA Exceptions first of all
		catch(Exception& ex) {
			QMessageBox::warning(0,
		                         tr("An error occurred"),
		                         QString::fromStdString( ex.message() ));
		}
		// catch other exceptions
		catch(...) {
			QMessageBox::warning(0,
		                         tr("An unexpected error occurred"),
		                         tr("This is likely a bug."));
		}
		return false;
	}
};

///////////////////////////////////////////////////////////////////////////////

} // namespace

#endif
