/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file ChannelView.h
 *    Description.
 *
 * @author Erik Einhorn
 * @date   2010/12/01
 */

#ifndef _MIRA_CHANNELVIEW_H_
#define _MIRA_CHANNELVIEW_H_

#include <rcp/ViewPart.h>
#include <serialization/adapters/Qt/QAction>

#include <QTreeWidget>

///////////////////////////////////////////////////////////////////////////////
namespace mira {
///////////////////////////////////////////////////////////////////////////////

class ChannelView : public ViewPart
{
MIRA_META_OBJECT(ChannelView,
				("Name", "Channels")
				("Description", "Lists all available channels"))
Q_OBJECT

public:
	ChannelView();

	template <typename Reflector>
	void reflect(Reflector& r)
	{
		r.property("ShowType",
		           getter<bool>(boost::bind(actionGetter, mShowType)),
		           setter<bool>(boost::bind(actionSetter, mShowType, _1)),
		           "Show data type", false);
		
		r.property("ShowIsTyped",
		           getter<bool>(boost::bind(actionGetter, mShowIsTyped)),
		           setter<bool>(boost::bind(actionSetter, mShowIsTyped, _1)),
		           "Show if channel is typed", false);

		r.property("ShowUpdateCount",
		           getter<bool>(boost::bind(actionGetter, mShowUpdateCount)),
		           setter<bool>(boost::bind(actionSetter, mShowUpdateCount, _1)),
		           "Show update count", false);

		r.property("ShowSlotCount",
		           getter<bool>(boost::bind(actionGetter, mShowSlotCount)),
		           setter<bool>(boost::bind(actionSetter, mShowSlotCount, _1)),
		           "Show slot count", false);

		r.property("ShowLastUpdate",
		           getter<bool>(boost::bind(actionGetter, mShowLastUpdate)),
		           setter<bool>(boost::bind(actionSetter, mShowLastUpdate, _1)),
		           "Show last update time", false);

		r.property("ShowPublisherSubscriber",
		           getter<bool>(boost::bind(actionGetter, mShowPublishersSubscribers)),
		           setter<bool>(boost::bind(actionSetter, mShowPublishersSubscribers, _1)),
		           "Show publishers/subscribers", false);

		r.property("HideFilterBarAct",
				   getter<bool>(boost::bind(actionGetter, mHideFilterBarAct)),
		           setter<bool>(boost::bind(actionSetter, mHideFilterBarAct, _1)),
		           "Automatically hide the filter bar", false);
	}

	virtual Qt::DockWidgetArea getDefaultDockArea() const {
		return Qt::LeftDockWidgetArea;
	}

protected:

	virtual QWidget* createPartControl();

protected slots:

	void updateChannelTree();

protected:

	virtual void timerEvent(QTimerEvent *e);

private:

	void insertChannel(const std::string& channelID);

private:
	std::map<std::string, std::pair<QTreeWidgetItem*, uint64>> mChannelItems;
	QAction* mShowType;
	QAction* mShowIsTyped;
	QAction* mShowUpdateCount;
	QAction* mShowLastUpdate;
	QAction* mShowPublishersSubscribers;
	QAction* mShowSlotCount;
	QAction* mHideFilterBarAct;

	int mUpdateTimerId;

	struct UI;
	UI* mUI;
};

///////////////////////////////////////////////////////////////////////////////
}
///////////////////////////////////////////////////////////////////////////////

#endif
