#!/bin/bash

################################################################################

function miraindex
{
	if [[ $1 = "--help" ]]; then
		echo -e "Usage: miraindex\n\nUpdate the index of installed mira packages (used by mira bash tools)."
		return 0
	fi

	bash $MIRA_SCRIPT_DIR/bash/miraindex.bash ${@:1}
	return $?
}

################################################################################

# change path to an installed package root dir by typing the package name
# supports tab completion
function miracd
{
	if [[ $1 = "--help" ]] || [[ $# -lt 1 ]]; then
		echo -e "Usage: miracd <package>[:<path>]\n\nGo to the location of the target package."
		return 0
	fi

	# add colon, if not yet included
	local arg=$1
	if [[ ! $arg =~ : ]]; then
		arg="$1:"
	fi
	
	_mira_split_path $arg
	if [ $? != 2 ]; then
		echo "miracd: No such package '$1'"
		return 1
	fi
	cd ${_mira_split_path_var[4]}
	
	return 0
}

complete -F _miracomplete_subdirs -o nospace miracd

################################################################################

# list contents of installed package root dirs by typing the package name
# supports tab completion
function mirals
{
	local miravals
	if [[ $1 = "--help" ]]; then
		echo -e "Usage: mirals <package>[:<path>]\n\nLists contents of a package directory."
		return 0
	fi

	# add colon, if not yet included
	local arg=$1
	if [[ ! $arg =~ : ]]; then
		arg="$1:"
	fi
	_mira_split_path $arg
	if [ $? == 1 ]; then
		echo "miracd: No such package '$1'"
		return 1
	fi
	ls ${_mira_split_path_var[4]} ${@:2}
	return 0
}

complete -F _miracomplete_subdirs -o nospace mirals

################################################################################

# list contents of installed package root dirs by typing the package name
# supports tab completion
function miracp
{
	local miravals
	if [[ $1 = "--help" ]]; then
		echo -e "Usage: miracp <srcpackage>:<srcpath> <destpackage>:<destpath>"
		echo -e "       miracp <path> <destpackage>:<destpath>"
		echo -e "       miracp <srcpackage>:<srcpath> <path>\n"
		echo -e "Copies files or a directory from the source to the target."
		return 0
	fi

	local src=$1
	if [[ $1 =~ : ]]; then
		_mira_split_path $1
		src=${_mira_split_path_var[4]}
	fi

	local dest=$2
	if [[ $2 =~ : ]]; then
		_mira_split_path $2
		dest=${_mira_split_path_var[4]}
	fi

	cp ${src} ${dest} ${@:3}
	return 0
}

complete -F _miracomplete_pkgandfiles -o nospace miracp

################################################################################

function miraedit
{
	bash $MIRA_SCRIPT_DIR/bash/miraedit.bash ${@:1}
	return $?
}

complete -F _miracomplete_pkgandfiles -o nospace miraedit

################################################################################

function miramk
{
	bash $MIRA_SCRIPT_DIR/bash/miramk.bash ${@:1}
	return $?
}

function _miracomplete_miramkproc {
	case "$1" in
	0) _miracomplete_packages;;
	1) ;;
	2) 	echo "debug"; echo "release"; echo "relwithdebinfo" ;;
	esac
}

function _miracomplete_miramk {
	_mira_completion _miracomplete_miramkproc
}

complete -F _miracomplete_miramk -o nospace miramk

################################################################################

function mirasvn
{
	bash $MIRA_SCRIPT_DIR/bash/mirasvn.bash ${@:1}
	return $?
}

function _miracomplete_mirasvnproc {
	case "$1" in
	0) _miracomplete_packages;;
	1) ;;
	2) _miracomplete_packages;;
	esac
}

function _miracomplete_mirasvn {
	if [[ $COMP_CWORD == 1 ]]; then
		local ARG="${COMP_WORDS[COMP_CWORD]}"
		COMPREPLY=(${COMPREPLY[@]} $(compgen -W "
			changes
			commit
			info
			up
			status" -- ${ARG}))
	else
		_mira_completion _miracomplete_mirasvnproc
	fi
}

complete -F _miracomplete_mirasvn mirasvn

################################################################################