###############################################################################
# Copyright (C) 2012 by
#   MetraLabs GmbH (MLAB), GERMANY
# and
#   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
# All rights reserved.
#
# Contact: info@mira-project.org
#
# Commercial Usage:
#   Licensees holding valid commercial licenses may use this file in
#   accordance with the commercial license agreement provided with the
#   software or, alternatively, in accordance with the terms contained in
#   a written agreement between you and MLAB or NICR.
#
# GNU General Public License Usage:
#   Alternatively, this file may be used under the terms of the GNU
#   General Public License version 3.0 as published by the Free Software
#   Foundation and appearing in the file LICENSE.GPL3 included in the
#   packaging of this file. Please review the following information to
#   ensure the GNU General Public License version 3.0 requirements will be
#   met: http://www.gnu.org/copyleft/gpl.html.
#   Alternatively you may (at your option) use any later version of the GNU
#   General Public License if such license has been publicly approved by
#   MLAB and NICR (or its successors, if any).
#
# IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
# INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
# THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
# "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
# BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
# FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
# ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
# PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
#
###############################################################################
#
# Macros for using Qt5 in MIRA
#
###############################################################################

#find_package(Qt5Widgets REQUIRED) # this is already done in Qt.cmake

set(_MIRAQt5RequiredModulesList Concurrent Core DBus Gui Multimedia MultimediaWidgets Network OpenGL PrintSupport Qml Quick QuickTest QuickWidgets Script ScriptTools Sql Svg Test WebKit WebKitWidgets Widgets Xml LinguistTools)
find_package(Qt5 REQUIRED ${_MIRAQt5RequiredModulesList})

foreach(module ${_MIRAQt5RequiredModulesList})
	set(qt_module Qt${module})
	set(qt5_module Qt5${module})

	INCLUDE_DIRECTORIES(${${qt5_module}_INCLUDE_DIRS})

	# Also include private include directories. This is in relation to this bug: https://bugreports.qt.io/browse/QTBUG-37417
	if("${${qt5_module}_PRIVATE_INCLUDE_DIRS}" STREQUAL "")
		foreach(base_dir ${${qt5_module}_INCLUDE_DIRS})
			if("${base_dir}" MATCHES "/${qt_module}\$")
				list(APPEND ${qt5_module}_PRIVATE_INCLUDE_DIRS "${base_dir}/${${qt5_module}_VERSION}/${qt_module}")
			endif()
		endforeach()
	endif()
	INCLUDE_DIRECTORIES(${${qt5_module}_PRIVATE_INCLUDE_DIRS})
endforeach()

# enable deprecated method (Qt4 compatibility)
add_definitions(-DQT_DISABLE_DEPRECATED_BEFORE=0x000000)

set(QT_QTCORE_LIBRARY ${Qt5Core_LIBRARIES})
set(QT_QTGUI_LIBRARY ${Qt5Gui_LIBRARIES} ${Qt5Widgets_LIBRARIES})
set(QT_QTOPENGL_LIBRARY ${Qt5Gui_LIBRARIES} ${Qt5OpenGL_LIBRARIES})
set(QT_QTSVG_LIBRARY ${Qt5Svg_LIBRARIES})
set(QT_QTTEST_LIBRARY ${Qt5Test_LIBRARIES})
set(QT_QTQML_LIBRARY ${Qt5Qml_LIBRARIES})
set(QT_QTXML_LIBRARY ${Qt5Xml_LIBRARIES})
set(QT_QTDECLARATIVE_LIBRARY ${Qt5Declarative_LIBRARIES})
set(QT_QTQUICK_LIBRARY ${Qt5Quick_LIBRARIES})
set(QT_QTMULTIMEDIA_LIBRARY ${Qt5Multimedia_LIBRARIES})
set(QT_QTMULTIMEDIAWIDGETS_LIBRARY ${Qt5MultimediaWidgets_LIBRARIES})
set(QT_QTWEBKIT_LIBRARY ${Qt5WebKit_LIBRARIES})
set(QT_QTNETWORK_LIBRARY ${Qt5Network_LIBRARIES})
set(QT_LRELEASE_EXECUTABLE ${Qt5_LRELEASE_EXECUTABLE})
set(QT_LUPDATE_EXECUTABLE ${Qt5_LUPDATE_EXECUTABLE})
set(CMAKE_CXX_FLAGS_RELEASE "${CMAKE_CXX_FLAGS_RELEASE} -DQT_NO_DEBUG")
set(CMAKE_CXX_FLAGS_RELWITHDEBINFO "${CMAKE_CXX_FLAGS_RELWITHDEBINFO} -DQT_NO_DEBUG")

macro(qt_wrap_ui)
	qt5_wrap_ui(${ARGN})
endmacro()

macro(qt_wrap_cpp)
	qt5_wrap_cpp(${ARGN})
endmacro()

macro(qt_generate_moc)
	qt5_generate_moc(${ARGN})
endmacro()

macro(qt_add_dbus_adaptor)
	qt5_add_dbus_adaptor(${ARGN})
endmacro()

macro(qt_add_dbus_interfaces)
	qt5_add_dbus_interfaces(${ARGN})
endmacro()

macro(qt_add_dbus_interface)
	qt5_add_dbus_interface(${ARGN})
endmacro()

macro(qt_generate_dbus_interface)
	qt5_generate_dbus_interface(${ARGN})
endmacro()

macro(qt_add_resources)
	qt5_add_resources(${ARGN})
endmacro()
