###############################################################################
# Copyright (C) 2012 by
#   MetraLabs GmbH (MLAB), GERMANY
# and
#   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
# All rights reserved.
#
# Contact: info@mira-project.org
#
# Commercial Usage:
#   Licensees holding valid commercial licenses may use this file in
#   accordance with the commercial license agreement provided with the
#   software or, alternatively, in accordance with the terms contained in
#   a written agreement between you and MLAB or NICR.
#
# GNU General Public License Usage:
#   Alternatively, this file may be used under the terms of the GNU
#   General Public License version 3.0 as published by the Free Software
#   Foundation and appearing in the file LICENSE.GPL3 included in the
#   packaging of this file. Please review the following information to
#   ensure the GNU General Public License version 3.0 requirements will be
#   met: http://www.gnu.org/copyleft/gpl.html.
#   Alternatively you may (at your option) use any later version of the GNU
#   General Public License if such license has been publicly approved by
#   MLAB and NICR (or its successors, if any).
#
# IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
# INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
# THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
# "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
# BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
# FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
# ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
# PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
#
###############################################################################
#
# Macros for using Qt4 in MIRA
#
###############################################################################

FIND_PACKAGE(Qt4 REQUIRED)

# TODO Test this and remove it if CMake fixes FindQt4 and includes also QtDeclarative
IF(WIN32)
	SET (QT_QTDECLARATIVE_LIBRARY QtDeclarative.dll)
ELSE()
	SET (QT_QTDECLARATIVE_LIBRARY libQtDeclarative.so)
ENDIF()

INCLUDE_DIRECTORIES(
	${QT_INCLUDES}
)

###############################################################################

macro(qt_wrap_ui)
	qt4_wrap_ui(${ARGN})
endmacro()

macro(qt_wrap_cpp)
	qt4_wrap_cpp(${ARGN})
endmacro()

macro(qt_generate_moc)
	qt4_generate_moc(${ARGN})
endmacro()

macro(qt_add_dbus_adaptor)
	qt4_add_dbus_adaptor(${ARGN})
endmacro()

macro(qt_add_dbus_interfaces)
	qt4_add_dbus_interfaces(${ARGN})
endmacro()

macro(qt_add_dbus_interface)
	qt4_add_dbus_interface(${ARGN})
endmacro()

macro(qt_generate_dbus_interface)
	qt4_generate_dbus_interface(${ARGN})
endmacro()

macro(qt_add_resources)
	qt4_add_resources(${ARGN})
endmacro()

###############################################################################

MACRO(MIRA_QT4_UI target)
	QT4_EXTRACT_OPTIONS(ui_files ui_options ${ARGN})

	FOREACH (it ${ui_files})
		GET_FILENAME_COMPONENT(outfile ${it} NAME_WE)
		GET_FILENAME_COMPONENT(infile ${it} ABSOLUTE)
		SET(outfile ${CMAKE_CURRENT_BINARY_DIR}/ui_${outfile}.h)
		ADD_CUSTOM_COMMAND(OUTPUT ${outfile}
		                   COMMAND ${QT_UIC_EXECUTABLE}
		                   ARGS ${ui_options} -o ${outfile} ${infile}
		                   MAIN_DEPENDENCY ${infile})
		SET(${outfiles} ${${outfiles}} ${outfile})
	ENDFOREACH (it)

	# we need to add the include directory
	INCLUDE_DIRECTORIES(${CMAKE_CURRENT_BINARY_DIR})
ENDMACRO(MIRA_QT4_UI)

###############################################################################
# On Windows make sure, that a debug version of Qt is installed. Otherwise
# some functions will not work properly! For example, QString::toStdString()
# will return an invalid string, which will cause a crash.

IF(WIN32 AND ("${CMAKE_BUILD_TYPE}" STREQUAL "Debug"))
	IF( (${QT_QTCORE_LIBRARY_DEBUG} STREQUAL ${QT_QTCORE_LIBRARY_RELEASE}) OR
		(${QT_QTGUI_LIBRARY_DEBUG} STREQUAL ${QT_QTGUI_LIBRARY_RELEASE}) )
		MESSAGE(FATAL_ERROR "No debug version of Qt available!") 
	ENDIF()
ENDIF()

###############################################################################
