###############################################################################
# Copyright (C) 2012 by
#   MetraLabs GmbH (MLAB), GERMANY
# and
#   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
# All rights reserved.
#
# Contact: info@mira-project.org
#
# Commercial Usage:
#   Licensees holding valid commercial licenses may use this file in
#   accordance with the commercial license agreement provided with the
#   software or, alternatively, in accordance with the terms contained in
#   a written agreement between you and MLAB or NICR.
#
# GNU General Public License Usage:
#   Alternatively, this file may be used under the terms of the GNU
#   General Public License version 3.0 as published by the Free Software
#   Foundation and appearing in the file LICENSE.GPL3 included in the
#   packaging of this file. Please review the following information to
#   ensure the GNU General Public License version 3.0 requirements will be
#   met: http://www.gnu.org/copyleft/gpl.html.
#   Alternatively you may (at your option) use any later version of the GNU
#   General Public License if such license has been publicly approved by
#   MLAB and NICR (or its successors, if any).
#
# IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
# INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
# THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
# "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
# BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
# FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
# ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
# PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
#
###############################################################################
# Check the Microsoft compiler
###############################################################################

IF(NOT WIN32)
	MESSAGE(FATAL_ERROR "Only use this cmake-Script on Windows.")
ENDIF()

IF(NOT MSVC)
	MESSAGE(FATAL_ERROR "The compiler is not a MSVC compiler.")
ENDIF()

IF(NOT MSVC10 AND NOT MSVC11 AND NOT MSVC12)
	MESSAGE(FATAL_ERROR "You need to install MSVC10.0 (Visual Studio 2010) or MSVC11.0 (Visual Studio 2012) or MSVC12.0 (Visual Studio 2013) compiler.")
ENDIF()

###############################################################################
# Some important settings and warnings

# We want at least WindowsVista
ADD_DEFINITIONS(-D_WIN32_WINNT=0x0600)

# Enable useful mathematical constants (M_E, M_PI, M_PI_2, ...)
ADD_DEFINITIONS(-D_USE_MATH_DEFINES)

# Disable warnings about some deprecated or unsafe windows functions
ADD_DEFINITIONS(-D_SCL_SECURE_NO_WARNINGS)
ADD_DEFINITIONS(-D_CRT_SECURE_NO_WARNINGS)

# Prevent windows.h from defining 'min' and 'max', since we use Eigen
ADD_DEFINITIONS(-DNOMINMAX)

# Prevent critical error C1128
ADD_DEFINITIONS(/bigobj)

# Increase limit for precompiled headers to avoid C3859 and C1076
ADD_DEFINITIONS(/Zm1000)

###############################################################################
# append _d to debug binaries and libraries

# append _d to debug libraries
SET(CMAKE_DEBUG_POSTFIX "_d")
SET(CMAKE_RELWITHDEBINFO_POSTFIX "_rd")

# since the above setting do not apply to executables, we have 
# to handle them explicitly. Thank cmake for this inconsistent behavior.
if(${CMAKE_BUILD_TYPE} STREQUAL "Debug")
	SET(CMAKE_EXECUTABLE_SUFFIX "_d.exe")
endif()

if(${CMAKE_BUILD_TYPE} STREQUAL "RelWithDebInfo")
	SET(CMAKE_EXECUTABLE_SUFFIX "_rd.exe")
endif()