/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */


#include <QApplication>

#include <visualization/3d/AxesVisualization.h>

#include <visualization/Visualization3DContainer.h>
#include <widgets/PropertyEditor.h>

using namespace mira;
int main(int argc, char** argv)
{
	QApplication qapp(argc,argv);

	// we need to fire up a framework, since most visualizations obtain
	// their data from channels
	Framework fw(argc,argv);

	// create a visualization container widget, were we can add
	// the visualizations. The widget is a Ogre 3D view.
	Visualization3DContainer* widget = new Visualization3DContainer();

	// create a visualization instance
	Visualization3D* v1 = new AxesVisualization();
	v1->setName("Axes"); // set a name for the property editor
	// add the visualization to our view
	widget->addVisualization(v1);

	// create a visualization by class name. This is usefull, since most
	// visualization do not a header and must be created via the class factory
	Visualization3D* v2 = widget->addVisualization("mira::gui::GroundPlaneVisualization");

	// show the visualization container widget with both visualizations
	widget->show();

	// the properties of the visualizations can be modified easily
	widget->setProperty(v2,"CellCount",100);
	std::cout << "CellCount is now: " <<
	    widget->getPropertyString(v2, "CellCount") << std::endl;

	// we can optionally obtain a property editor, where the user can change
	// the properties manually
	PropertyEditor* editor = widget->getPropertyEditor();
	editor->show();

	int res = qapp.exec();

	delete widget;
	return res;
}
