/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file Point3BasicVisualization.C
 *    Example for a basic visualization of a point by a sphere mesh.
 *
 * @author Tim Langner
 * @date   2011/06/25
 */

#include <visualization/Visualization3DBasic.h>
#include <geometry/Point.h>
#include <visualization/3d/MeshObject.h>

using namespace mira;

class Point3BasicVisualization : public Visualization3DBasic<Point3f>
{
MIRA_META_OBJECT(Point3BasicVisualization,
			("Name", "Point")
			("Category", "Geomtery")
			("Description", "Visualizes a point."))

public:

	Point3BasicVisualization() :
		Visualization3DBasic<Point3f>("Point"),
		mPoint(NULL)
	{}

	virtual ~Point3BasicVisualization()
	{
		delete mPoint;
	}

	virtual void setupScene(Ogre::SceneManager* mgr, Ogre::SceneNode* node)
	{
		mPoint = new MeshObject("Sphere.mesh", mgr, node);
	}

protected:

	virtual void dataChanged(ChannelRead<Point3f> point)
	{
		Ogre::Vector3 p = OgreUtils::toOgreVector(point->value());
		mPoint->setPosition(p);
	}

protected:

	MeshObject* mPoint;
};

MIRA_CLASS_SERIALIZATION(Point3BasicVisualization, mira::Visualization3D);
