/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file XMLDomModifierTest.C
 *
 * @author Tim Langner
 * @date   2011/02/26
 */

#include <boost/test/unit_test.hpp>

#include <iostream>
#include <xml/XMLDomPreprocessor.h>

using namespace mira;
using namespace std;

XMLDom prepareDocuments(bool includeSpecialVariables)
{
	XMLDom xmlInclude;
	xmlInclude.root().
		add_child("IncludedNode").
		add_attribute("IntAttribute", 1).
		add_comment("This is a comment").
		add_content("This is content");
	xmlInclude.saveToFile("Include.xml");
	
	XMLDom xml;
	xml.root().
		add_child("include").
		add_attribute("file", "Include.xml");
	xml.root().
		add_child("if").
		add_attribute("color", "red").
		add_child("Red");
	xml.root().
		add_child("if").
		add_attribute("color", "green").
		add_child("Green");
	xml.root().
		add_child("if").
		add_attribute("color", "blue").
		add_child("include").
		add_attribute("file", "NonExistentInclude.xml");
	xml.root().
		add_child("if").
		add_attribute("name", "peter").
		add_child("Peter");
	xml.root().
		add_child("else").
		add_child("Heidi");
	if (includeSpecialVariables)
	{
		xml.root().
			add_child("RealName").
			add_attribute("name", "${name}");
		xml.root().
			add_child("RealColor").
			add_content("${color}");
	}
	return xml;
}

BOOST_AUTO_TEST_CASE( testInclude )
{
	XMLDom xml = prepareDocuments(false);
	XMLVariablesMap variables;
	preprocessXML(xml, variables);
	xml.saveToFile("ResolvedInclude.xml");
	BOOST_CHECK(xml.root().find("IncludedNode") != xml.root().end());
}

BOOST_AUTO_TEST_CASE( testIfReplace )
{
	XMLDom xml = prepareDocuments(true);
	XMLVariablesMap variables;
	variables["color"] = "red";
	variables["name"] = "peter";
	preprocessXML(xml, variables);
	xml.saveToFile("ResolvedIfTags.xml");
	BOOST_CHECK(xml.root().find("Red") != xml.root().end());
	BOOST_CHECK(xml.root().find("Peter") != xml.root().end());
	BOOST_CHECK(xml.root().find("RealName").get_attribute<std::string>("name") == "peter");
	BOOST_CHECK(*xml.root().find("RealColor").content_begin() == "red");
}

