/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file MathTest.C
 *    this file contains test cases for helper functions of math
 *
 * @author volksen
 * @date   2010/04/21
 */

#include <iostream>

#include <boost/test/unit_test.hpp>
#include <boost/test/floating_point_comparison.hpp>

#include <math/NormCDF.h>
#include <math/Saturate.h>
#include <math/Truncate.h>
#include <math/Math.h>

using namespace std;
using namespace mira;

BOOST_AUTO_TEST_CASE( NormCDFTest )
{
	float cdf = normcdf(0, 0.0, 1.0);
	BOOST_CHECK_CLOSE(cdf,0.5,0.0001);
	float cdf1 = normcdf(1, 0.0, 2.0);
	BOOST_CHECK_CLOSE(cdf1,0.691462457,0.001);
	float cdf2 = normcdf(-4, -1.0, 1.0);
	BOOST_CHECK_CLOSE(cdf2,0.00134989806,0.001);
}

BOOST_AUTO_TEST_CASE( SaturateTest )
{
	float sat1 = saturate<float> (5.f, 1.f, 4.2f);
	BOOST_CHECK_CLOSE(sat1,4.2,0.0001);

	int sat2 = saturate<int> (5, 6, 7);
	BOOST_CHECK(sat2 ==6);

	double sat3 = saturate<double> (6.22, 6, 7);
	BOOST_CHECK_CLOSE(sat3,6.22,0.0001);
}

BOOST_AUTO_TEST_CASE( TruncateTest )
{ 
	BOOST_CHECK_CLOSE(mira::truncate(pi<float>(),3), 3.141f, 0.0001f);
	BOOST_CHECK_CLOSE(mira::truncate(-pi<float>(),3), -3.141f, 0.0001f);
	BOOST_CHECK_CLOSE(mira::truncate(pi<double>(),3), 3.141, 0.0001);
	BOOST_CHECK_CLOSE(mira::truncate(-pi<double>(),3), -3.141, 0.0001);
}

