/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file RegistrationTest.h
 *    $Test double class registration.$.
 *
 * @author Ronny Stricker
 * @date   2010/10/25
 */

#include <boost/test/unit_test.hpp>
#include <classes/DiamondClassStructure.h>

using namespace std;

namespace mira {

//////////////////////////////////////////////////////////////////////////////

void registerClassAsParent() {
    FactoryRegisterClass<I, I> tRegister;
}

BOOST_AUTO_TEST_CASE( DoubleClassRegister )
{
    // a class cannot be the parent of itself
    BOOST_CHECK_THROW( registerClassAsParent(), mira::XLogical );
}

BOOST_AUTO_TEST_CASE( UnregisterClass )
{
	BOOST_CHECK_EQUAL( ClassFactory::isClassRegistered(I::CLASS().getIdentifier()), true );
	BOOST_CHECK_EQUAL( A::CLASS().isClassRegistered(I::CLASS().getIdentifier()), true );
	BOOST_CHECK_EQUAL( B::CLASS().isClassRegistered(I::CLASS().getIdentifier()), true );
	BOOST_CHECK_EQUAL( C::CLASS().isClassRegistered(I::CLASS().getIdentifier()), false );
	
	// remove Class I from the class factory
	ClassFactory::unregisterClass( const_cast<mira::TClass<mira::I>* >( &I::CLASS() ) );
	
	BOOST_CHECK_EQUAL( ClassFactory::isClassRegistered(I::CLASS().getIdentifier()), false );
	BOOST_CHECK_EQUAL( A::CLASS().isClassRegistered(I::CLASS().getIdentifier()), false );
	BOOST_CHECK_EQUAL( B::CLASS().isClassRegistered(I::CLASS().getIdentifier()), false );
	BOOST_CHECK_EQUAL( C::CLASS().isClassRegistered(I::CLASS().getIdentifier()), false );

	// remove second class
	BOOST_CHECK_EQUAL( ClassFactory::isClassRegistered(A::CLASS().getIdentifier()), true );
	BOOST_CHECK_EQUAL( C::CLASS().isDirectlyDerivedFrom( &A::CLASS() ), true );
	BOOST_CHECK_EQUAL( D::CLASS().isDirectlyDerivedFrom( &A::CLASS() ), true );

	ClassFactory::unregisterClass( const_cast<mira::TClass<mira::A>* >( &A::CLASS() ) );

	BOOST_CHECK_EQUAL( ClassFactory::isClassRegistered(A::CLASS().getIdentifier()), false );
	BOOST_CHECK_EQUAL( C::CLASS().isDirectlyDerivedFrom( &A::CLASS() ), false );
	BOOST_CHECK_EQUAL( D::CLASS().isDirectlyDerivedFrom( &A::CLASS() ), false );


	BOOST_CHECK_EQUAL( G::CLASS().isDirectlyDerivedFrom( &B::CLASS() ), false );
	BOOST_CHECK_EQUAL( F::CLASS().isDirectlyDerivedFrom( &B::CLASS() ), false );

	ClassFactory::unregisterClass( const_cast<mira::TClass<mira::E>* >( &E::CLASS() ) );

	BOOST_CHECK_EQUAL( G::CLASS().isDirectlyDerivedFrom( &B::CLASS() ), true );
	BOOST_CHECK_EQUAL( F::CLASS().isDirectlyDerivedFrom( &B::CLASS() ), true );

}

//////////////////////////////////////////////////////////////////////////////

} // namespace
