/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file ChatView.C
 *    .
 *
 * @author Tim Langner
 * @date   03.02.2011
 */


#include <views/ChatView.h>

#include <QVBoxLayout>

///////////////////////////////////////////////////////////////////////////////

MIRA_CLASS_SERIALIZATION(mira::ChatView, mira::ViewPart);

///////////////////////////////////////////////////////////////////////////////

namespace mira {
///////////////////////////////////////////////////////////////////////////////

ChatView::ChatView() : ui(NULL)
{
}

QWidget* ChatView::createPartControl()
{
	ui = new UI(this);
	return ui;
}


ChatView::UI::UI(QWidget* parent) :
	QWidget(parent),
	authority("/", "ChatView")
{
	authority.publish<std::string>("ChatText");
	channel = authority.subscribe<std::string>("ChatText", &ChatView::UI::onNewText, this);
	QVBoxLayout* vLayout = new QVBoxLayout(this);
	vLayout->setContentsMargins(0, 0, 0, 0);
	text = new QTextEdit(this);
	text->setEnabled(false);
	edit = new QLineEdit(this);
	vLayout->addWidget(text);
	vLayout->addWidget(edit);
	connect(edit, SIGNAL(editingFinished()), this, SLOT(edited()));
}

void ChatView::UI::onNewText(ChannelRead<std::string> r)
{
	text->append(std::string("on <em>" + toString(r->timestamp) + " </em>" + r->value()).c_str());
}

void ChatView::UI::edited()
{
	std::string t(edit->text().toLocal8Bit().data());
	if (!t.empty())
	{
		std::string text;
		text = "<em>"+toString(MIRA_FW.getID()) + "</em> wrote: ";
		text += "<strong>" + t + "</strong>";
		channel.post(text);
	}

	edit->setText("");
}




}
