###############################################################################
# OpenSSL
###############################################################################

IF(WIN32)
	# On Windows, download OpenSSL
	
	if(CMAKE_SIZEOF_VOID_P EQUAL 8)
		set(OPENSSL_URL "http://www.mira-project.org/downloads/3rdparty/bin-win64/openssl-0.9.8e.win64.zip" )
	else()
		set(OPENSSL_URL "http://www.mira-project.org/downloads/3rdparty/bin-win32/openssl-1.0.1j.win32.zip" )
	endif()

	MIRA_EXTERNAL_PROJECT(OpenSSL
		URL ${OPENSSL_URL}

		PREFIX       ${MIRA_ROOT_DIR}/external/openssl
		STAMP_DIR    ${MIRA_ROOT_DIR}/external/openssl/cmake
		TMP_DIR      ${MIRA_ROOT_DIR}/external/openssl/cmake
		DOWNLOAD_DIR ${MIRA_ROOT_DIR}/external/openssl
		SOURCE_DIR   ${MIRA_ROOT_DIR}/external/openssl/openssl
		BINARY_DIR   ${MIRA_ROOT_DIR}/external/openssl/openssl
		CONFIGURE_COMMAND "" # no configure step
		BUILD_COMMAND     "" # no build step
		INSTALL_COMMAND   "" # no install step
	)

	SET(OPENSSL_INCLUDE_DIRS
		"${MIRA_ROOT_DIR}/external/openssl/openssl/include"
	)

	SET(OPENSSL_LIBRARY_DIRS
		"${MIRA_ROOT_DIR}/external/openssl/openssl/lib"
	)

	SET(OPENSSL_LIBRARIES
		"libeay32"
	)

	MIRA_DIST_LIBRARY_EX(OpenSSL ${MIRA_ROOT_DIR}/external/openssl/openssl/bin/libeay32.dll)
	MIRA_DIST_LIBRARY_EX(OpenSSL ${MIRA_ROOT_DIR}/external/openssl/openssl/bin/ssleay32.dll)

	MIRA_INSTALL(
		DIRECTORY ${MIRA_ROOT_DIR}/external/openssl/openssl/include
		DESTINATION external/openssl/openssl
		PACKAGE external
		FILES_MATCHING
		PATTERN "*"
		PATTERN ".svn" EXCLUDE
	)

	MIRA_INSTALL(
		DIRECTORY ${MIRA_ROOT_DIR}/external/openssl/openssl/lib
		DESTINATION .
		PACKAGE external
		FILES_MATCHING
		PATTERN "*.lib"
	)

	MIRA_INSTALL(
		DIRECTORY ${MIRA_ROOT_DIR}/external/openssl/openssl/bin
		DESTINATION .
		PACKAGE external
		FILES_MATCHING
		PATTERN "*.dll"
		PATTERN "PEM" EXCLUDE
	)

ELSE(WIN32)
	# On Linux, use pkg-config to get openssl settings

	pkg_check_modules(OPENSSL REQUIRED openssl)

ENDIF(WIN32)

###############################################################################

IF (CMAKE_VERBOSE_MAKEFILE)
	MESSAGE(STATUS "OPENSSL")
	MESSAGE(STATUS "   incdir = " ${OPENSSL_INCLUDE_DIRS})
	MESSAGE(STATUS "   libdir = " ${OPENSSL_LIBRARY_DIRS})
	MESSAGE(STATUS "   libs   = " ${OPENSSL_LIBRARIES})
ENDIF (CMAKE_VERBOSE_MAKEFILE)
