###############################################################################
# Eigen C++ Math Template-Library
###############################################################################

MIRA_EXTERNAL_PROJECT(Eigen
#	URL http://www.mira-project.org/downloads/3rdparty/src/eigen-3.1.2.tar.gz
#	URL http://bitbucket.org/eigen/eigen/get/3.2.0.tar.bz2
#	URL http://www.mira-project.org/downloads/3rdparty/src/eigen-3.2.0.tar.gz
#	URL http://www.mira-project.org/downloads/3rdparty/src/eigen-3.2.1.tar.bz2
	URL http://www.mira-project.org/downloads/3rdparty/src/eigen-3.3.5.tar.bz2

	PREFIX       ${MIRA_ROOT_DIR}/external/eigen
	STAMP_DIR    ${MIRA_ROOT_DIR}/external/eigen/cmake
	TMP_DIR      ${MIRA_ROOT_DIR}/external/eigen/cmake
	DOWNLOAD_DIR ${MIRA_ROOT_DIR}/external/eigen
	SOURCE_DIR   ${MIRA_ROOT_DIR}/external/eigen/eigen
	BINARY_DIR   ${MIRA_ROOT_DIR}/external/eigen/eigen
	CONFIGURE_COMMAND "" # no configure step
	BUILD_COMMAND     "" # no build step
	INSTALL_COMMAND   "" # no install step
)

###############################################################################

IF(WIN32)

	# Don't care about vectorization in eigen, until we find a better solution
	# (see http://eigen.tuxfamily.org/dox/UnalignedArrayAssert.html).
	ADD_DEFINITIONS(-DEIGEN_DONT_VECTORIZE)
	ADD_DEFINITIONS(-DEIGEN_DISABLE_UNALIGNED_ARRAY_ASSERT)

	# Disable Eigen alignment completely, since this leads to compiler errors.
	ADD_DEFINITIONS(-DEIGEN_DONT_ALIGN)

ENDIF()

###############################################################################

# Set the eigen include dir
SET(EIGEN_INCLUDE_DIRS "${MIRA_ROOT_DIR}/external/eigen/eigen")

IF (CMAKE_VERBOSE_MAKEFILE)
	MESSAGE(STATUS "Eigen")
	MESSAGE(STATUS "   incdir = " ${EIGEN_INCLUDE_DIRS})
ENDIF (CMAKE_VERBOSE_MAKEFILE)

###############################################################################

MIRA_INSTALL(
	DIRECTORY ${MIRA_ROOT_DIR}/external/eigen/eigen/Eigen
	DESTINATION external/eigen/eigen
	PACKAGE external
	FILES_MATCHING
	PATTERN "*"
)

MIRA_INSTALL(
	DIRECTORY ${MIRA_ROOT_DIR}/external/eigen/eigen/debug
	DESTINATION external/eigen/eigen
	PACKAGE external
	FILES_MATCHING
	PATTERN "*"
)

MIRA_INSTALL(
	DIRECTORY ${MIRA_ROOT_DIR}/external/eigen/eigen/unsupported
	DESTINATION external/eigen/eigen
	PACKAGE external
	FILES_MATCHING
	PATTERN "*"
)

