/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file DataGenerator.C
 *
 * @author Tim Langner
 * @date   2011/02/07
 */

#include <fw/Unit.h>

namespace mira { namespace test {

///////////////////////////////////////////////////////////////////////////////

class DataGenerator : public Unit
{
	MIRA_OBJECT(DataGenerator)
public:
	DataGenerator() :
		Unit(Duration::milliseconds(50)),
		mCounter(0)
	{
	}

	template<typename Reflector>
	void reflect(Reflector& r)
	{
		Unit::reflect(r);
		r.property("DataSize", mSize, "Size in 4 byte packets", 1);
	}

	virtual void initialize()
	{
		mDataChannel = publish<std::vector<uint32>>("Data");
	}

	virtual void process(const Timer& timer)
	{
		ChannelWrite<std::vector<uint32>> value = mDataChannel.write();
		value->value().resize(mSize);
		value->value()[0] = mCounter++;
		value->timestamp = timer.current;
	}

protected:
	Channel<std::vector<uint32>> mDataChannel;
	int mSize;
	int mCounter;
};

///////////////////////////////////////////////////////////////////////////////

class DataConsumer : public MicroUnit
{
	MIRA_OBJECT(DataConsumer)
public:

	DataConsumer()
	{
		mExpected = -1;
	}

	void myCallback(ChannelRead<std::vector<uint32>> value)
	{
		if (mExpected>=0)
		{
			if (mExpected != (int)value->value()[0])
			{
				MIRA_LOG(ERROR) << getGlobalID() << ": Expected " << mExpected << " got " << value->value()[0];
			}
			else
				MIRA_LOG(NOTICE) << getGlobalID() << ": got " << value->value()[0];
		}
		mExpected = value->value()[0]+1;
	}

	virtual void initialize()
	{
		subscribe<std::vector<uint32>>("Data", &DataConsumer::myCallback);
	}

	int mExpected;
};

///////////////////////////////////////////////////////////////////////////////

}}

MIRA_CLASS_SERIALIZATION(mira::test::DataGenerator, mira::Unit);
MIRA_CLASS_SERIALIZATION(mira::test::DataConsumer, mira::MicroUnit);
