/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file TypedVoidPtrTest.C
 *    Test cases for TypedVoidPtr.h.
 *
 * @author Erik Einhorn
 * @date   2011/09/29
 */

#include <boost/test/unit_test.hpp>

#include <iostream>

#include <utils/TypedVoidPtr.h>

using namespace mira;
using namespace std;

BOOST_AUTO_TEST_CASE( TypedVoidPtrTest )
{
	struct Interface {
		virtual ~Interface() {}
		virtual void foo(TypedVoidPtr ptr) = 0;
	};

	struct IntHandler : public Interface {
		virtual void foo(TypedVoidPtr ptr) {
			int* p = ptr; // this cast is safe and will do full type check!
			std::cout << "Integer is: " << *p << std::endl;
		}
	};

	struct StringHandler : public Interface {
		virtual void foo(TypedVoidPtr ptr) {
			std::string* s = ptr; // this cast is safe and will do full type check!
			std::cout << "String is: " << *s << std::endl;
		}
	};

	Interface* i1 = new IntHandler;
	Interface* i2 = new StringHandler;

	int val = 123;
	i1->foo(&val);  // foo will internally cast back to int

	std::string s = "Hello world";
	i2->foo(&s);  // foo will internally cast back to string

	// will cause exception, since int cannot be casted into string in StringHandler::foo()
	BOOST_CHECK_THROW(i2->foo(&val), XBadCast);
}
