/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file SingletonTest.C
 *    Test cases for Singleton.h.
 *
 * @author Erik Einhorn
 * @date   2011/12/23
 */

#include <boost/test/unit_test.hpp>

#include <utils/Singleton.h>

using namespace mira;

class MySingleton1 :
	public Singleton<MySingleton1, singleton::LazyInstantiation>
{
public:
	MySingleton1() {
		std::cout << "MySingleton1" << std::endl;
	}

	~MySingleton1() {
		std::cout << "~MySingleton1" << std::endl;
	}

	int a;
};

class MySingleton2 :
	public Singleton<MySingleton2, singleton::EagerInstantiation>
{
public:
	MySingleton2() {
		std::cout << "MySingleton2" << std::endl;
	}

	~MySingleton2() {
		std::cout << "~MySingleton2" << std::endl;
	}

	int a;
};


class MySingleton3 :
	public Singleton<MySingleton3, singleton::ExplicitInstantiation>
{
public:
	MySingleton3() {
		std::cout << "MySingleton3" << std::endl;
	}

	~MySingleton3() {
		std::cout << "~MySingleton3" << std::endl;
	}

	int a;
};

class MySingleton4 :
	public Singleton<MySingleton4, singleton::LazyInstantiation, singleton::CreateStatic>
{
public:
	MySingleton4() {
		std::cout << "MySingleton4" << std::endl;
	}

	~MySingleton4() {
		std::cout << "~MySingleton4" << std::endl;
	}

	int a;
};

class MySingleton5 :
	public Singleton<MySingleton5, singleton::EagerInstantiation, singleton::CreateStatic>
{
public:
	MySingleton5() {
		std::cout << "MySingleton5" << std::endl;
	}

	~MySingleton5() {
		std::cout << "~MySingleton5" << std::endl;
		std::cout << MySingleton1::isDestroyed() << std::endl;
	}

	int a;
};

class MySingleton6 :
	public Singleton<MySingleton6, singleton::ExplicitInstantiation, singleton::CreateStatic>
{
public:
	MySingleton6() {
		std::cout << "MySingleton6" << std::endl;
	}

	~MySingleton6() {
		std::cout << "~MySingleton6" << std::endl;
	}

	int a;
};


class MySingleton7 : public Singleton<MySingleton7,
                        singleton::LazyInstantiation,singleton::CreateUsingNew,
                        singleton::NormalLifetime,singleton::MutexLock>
{
public:
	MySingleton7() {
		std::cout << "MySingleton7" << std::endl;
	}

	~MySingleton7() {
		std::cout << "~MySingleton7" << std::endl;
	}

	int a;
};



BOOST_AUTO_TEST_CASE( testSingleton )
{
	std::cout << "started" << std::endl;
	MySingleton1::instance().a=1;
	MySingleton2::instance().a=2;

	// this is expected to fail! (throws an exception and returns from test)
	//MySingleton3::instance().a=3;

	MySingleton3 s;
	MySingleton3::instance().a=3;

	MySingleton4::instance().a=4;
	MySingleton5::instance().a=5;

	// this is expected to fail! (throws an exception and returns from test)
	//MySingleton6::instance().a=3;

	MySingleton6 s2;
	MySingleton6::instance().a=6;

	MySingleton7::instance().a=7;
}

int testerA = 0;
int testerB = 0;

struct A {
	A() {
		std::cout << "Constructing A" << std::endl;
		testerA = 123;
	}
};

struct B {
	B() {
		std::cout << "Constructing B" << std::endl;
		testerB = 123;
	}
};


BOOST_AUTO_TEST_CASE( testCreationOrder )
{
	std::cout << "testerA: " << testerA << std::endl;
	std::cout << "testerB: " << testerB << std::endl;

	BOOST_CHECK_EQUAL(testerA, 123);
	// although we access the instance here, it should have been created
	// already before entering the entry point of this app, hence the
	// above check must pass.
	EagerSingleton<A>::instance();


	// the behavior of the lazy singleton should be different, here the
	// instance should not have been created yet
	BOOST_CHECK_EQUAL(testerB, 0);
	LazySingleton<B>::instance();

	// but after the lazy instantiation it should have been created.
	BOOST_CHECK_EQUAL(testerB, 123);
}

