/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file SHA256Test.C
 *    Test case for SHA256.
 *
 * @author Christian Martin
 * @date   2010/11/26
 */

#include <boost/test/unit_test.hpp>

#include <iostream>
#include <security/SHA256.h>

using namespace mira;
using namespace std;

///////////////////////////////////////////////////////////////////////////////

struct SHA256TestEntry {
	const char* mData;
	const char* mDigest;
};

// Test suite from FIPS 180-2
SHA256TestEntry sSHA256TestSuite[3] = {
	{ "abc",
	  "ba7816bf8f01cfea414140de5dae2223b00361a396177a9cb410ff61f20015ad" },
	{ "abcdbcdecdefdefgefghfghighijhijkijkljklmklmnlmnomnopnopq",
	  "248d6a61d20638b8e5c026930c3e6039a33ce45964ff2167f6ecedd419db06c1" },
	{ "", // A million repetitions of "a"
	  "cdc76e5c9914fb9281a1c7e284d73e67f1809a48a497200e046d39ccc7112cd0" } 
};

///////////////////////////////////////////////////////////////////////////////

BOOST_AUTO_TEST_CASE( SHA256Test_func )
{
	for(int i = 0; i < 3; i++) {
		SHA256 tSHA256;
		if (i == 2) {
			char tABuf[10000];
			for(int j = 0; j < 10000; j++)
				tABuf[j] = 'a';
			for(int j = 0; j < 100; j++)
				tSHA256.write((const char*)&tABuf, 10000);
		} else
			tSHA256.write(sSHA256TestSuite[i].mData,
			              strlen(sSHA256TestSuite[i].mData));

		HashDigest tDigest = tSHA256.getDigest();
		BOOST_CHECK_EQUAL(tDigest.toString(),
		                  string(sSHA256TestSuite[i].mDigest));
	}
}

BOOST_AUTO_TEST_CASE( SHA256Test_stream )
{
	for(int i = 0; i < 3; i++) {
		SHA256 tSHA256;
		if (i == 2) {
			char tABuf[10000];
			for(int j = 0; j < 10000; j++)
				tABuf[j] = 'a';
			for(int j = 0; j < 100; j++)
				tSHA256 << string((const char*)&tABuf, 10000);
		} else
			tSHA256 << sSHA256TestSuite[i].mData;

		HashDigest tDigest = tSHA256.getDigest();
		BOOST_CHECK_EQUAL(tDigest.toString(),
		                  string(sSHA256TestSuite[i].mDigest));
	}
}
