/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file RasterTriangleTest.C
 *    A test case for triangle rasterization.
 *
 * @author Erik Einhorn
 * @date   2010/12/06
 */

#include <boost/test/unit_test.hpp>

#include <geometry/RasterTriangle.h>
#include <iostream>

using namespace std;
using namespace mira;

///////////////////////////////////////////////////////////////////////////////

struct TriangleElement
{
	int x, y, length;
};

///////////////////////////////////////////////////////////////////////////////

struct TriangleGroundTruth
{
	int x0, y0, x1, y1, x2, y2;
	int groundTruthSize;
	TriangleElement groundTruth[32];
};

///////////////////////////////////////////////////////////////////////////////

TriangleGroundTruth triangleTests[] = {
	////////////////////
	{2,0, 0,6, 7,7,
		8, {
			{2,0, 1},
			{2,1, 2},
			{1,2, 3},
			{1,3, 4},
			{1,4, 5},
			{0,5, 7},
			{0,6, 7},
			{4,7, 4},
			}
	},
};

///////////////////////////////////////////////////////////////////////////////

class TriangleTester
{
public:

	TriangleTester(const TriangleGroundTruth& it) : t(it), i(0)
	{
		passed = true;
	}

	void operator()(int xl, int xr, int y)
	{
		int l =  (xr-xl+1);
		cout << "xl: " << xl << ",y: " << y << " l: " << l << endl;

		if(i>=t.groundTruthSize) {
			passed = false;
			cout << "too many segments! current segment: ("
			     << xl << ", " << y << ", " << l << ")" << endl;
		}

		const TriangleElement& e = t.groundTruth[i];
		if(e.x!=xl || e.y!=y || e.length!=l) {
			passed = false;
			cout << "wrong segment! is: ("
			     << xl << ", " << y << ", " << l
			     << "), should: ("
			     << e.x << ", " << e.y << ", " << e.length << ")" << endl;
		}
		++i;
	}

	const TriangleGroundTruth& t;
	int i;
	bool passed;
};

///////////////////////////////////////////////////////////////////////////////

void testTriangle(const TriangleGroundTruth& t)
{
	TriangleTester tester(t);
	rasterTriangle(Point2i(t.x0,t.y0), Point2i(t.x1,t.y1), Point2i(t.x2,t.y2),
	               tester);
	BOOST_CHECK(tester.passed);
}

///////////////////////////////////////////////////////////////////////////////

BOOST_AUTO_TEST_CASE( VisitorTest )
{
	for(size_t i = 0; i<sizeof(triangleTests)/sizeof(TriangleGroundTruth); ++i)
		testTriangle(triangleTests[i]);
}
