/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file TapePlayerView.C
 *    .
 *
 * @author Tim Langner
 * @date   2011/01/12
 */

#include <serialization/Serialization.h>

#include <views/TapePlayerView.h>
#include <fw/TapePlayerWidget.h>

//////////////////////////////////////////////////////////////////////////////

MIRA_CLASS_SERIALIZATION(mira::TapePlayerView, mira::ViewPart);

//////////////////////////////////////////////////////////////////////////////

namespace mira {

//////////////////////////////////////////////////////////////////////////////

TapePlayerView::TapePlayerView() : ui(NULL)
{
}

TapePlayerView::~TapePlayerView()
{
	if (ui)
		ui->stop();
}


QWidget* TapePlayerView::createPartControl()
{
	ui = new TapePlayerWidget(this);
	QStringList l;
	for(uint32 i=0; i<mLastTapes.size(); ++i)
		l.push_back(mLastTapes[i].c_str());
	ui->useOriginalTimestamp = mUseOriginalTimestamp;
	ui->namespacePrefix = mNamespacePrefix;
	try {
		ui->openTapes(l, mLastChannelsToPlay);
	} catch(Exception& ex) {
		MIRA_LOG(WARNING) << ex.what();
	}

	connect(ui, SIGNAL(onOpen(const QStringList&, bool, const QString&)),
	        this, SLOT(onOpen(const QStringList&, bool, const QString&)));
	connect(ui, SIGNAL(onStop()), this, SLOT(onStop()));
	return ui;
}

void TapePlayerView::onOpen(const QStringList& files, bool useOriginalTimestamp,
                            const QString& namespacePrefix)
{
	mLastTapes.clear();
	for (int32 i=0; i<files.size(); ++i)
		mLastTapes.push_back(files[i].toUtf8().data());
	mUseOriginalTimestamp = useOriginalTimestamp;
	mNamespacePrefix = namespacePrefix.toStdString();
}

void TapePlayerView::onStop()
{
	mLastTapes.clear();
}

void TapePlayerView::setLastChannelsToPlay(boost::optional<std::vector<std::string>> v)
{
	mLastChannelsToPlay = v;
	if(ui)
		ui->lastChannelsToPlay = mLastChannelsToPlay;
}

boost::optional<std::vector<std::string>> TapePlayerView::getLastChannelsToPlay()
{
	if(ui)
		mLastChannelsToPlay = ui->lastChannelsToPlay;
	return mLastChannelsToPlay;
}

//////////////////////////////////////////////////////////////////////////////

}
