/*
 * Copyright (C) by
 *   MetraLabs GmbH (MLAB), GERMANY
 *  and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Redistribution and modification of this code is strictly prohibited.
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file PanoramaCameraIntrinsic.C
 *    implementation of intrinsic parameters for Panorama cameras
 *    Cylindrical Equidistant Projection
 *
 * @author Michael Volkhardt
 * @date   2011/09/22
 */

#include <cameraparameters/PanoramaCameraIntrinsic.h>

using namespace Eigen;

namespace mira {
namespace camera {

///////////////////////////////////////////////////////////////////////////////

PanoramaCameraIntrinsicNormalized::PanoramaCameraIntrinsicNormalized() {
	minPhi = 0;
	maxPhi = 2 * M_PI;
	minHeight = 0.;
	maxHeight = 1.;
}

PanoramaCameraIntrinsicNormalized::PanoramaCameraIntrinsicNormalized(
		float iMinPhi, float iMaxPhi, float iMinHeight, float iMaxHeight) {

	minPhi = iMinPhi;
	maxPhi = iMaxPhi;
	minHeight = iMinHeight;
	maxHeight = iMaxHeight;

}

///////////////////////////////////////////////////////////////////////////////

PanoramaCameraIntrinsic::PanoramaCameraIntrinsic() {
	minPhi = 0;
	maxPhi = 2 * M_PI;
	minHeight = 0.;
	maxHeight = 1.;
}

PanoramaCameraIntrinsic::PanoramaCameraIntrinsic(float iMinPhi, float iMaxPhi,
		float iMinHeight, float iMaxHeight, float iWidth, float iHeight) {
	minPhi = iMinPhi;
	maxPhi = iMaxPhi;
	minHeight = iMinHeight;
	maxHeight = iMaxHeight;
	width = iWidth;
	height = iHeight;
}

PanoramaCameraIntrinsic::PanoramaCameraIntrinsic(
		const PanoramaCameraIntrinsicNormalized& iNormIntrinParm,
		const Size2i& iImageSize) {

	minPhi = iNormIntrinParm.minPhi;
	maxPhi = iNormIntrinParm.maxPhi;
	minHeight = iNormIntrinParm.minHeight;
	maxHeight = iNormIntrinParm.maxHeight;
	width = iImageSize.width();
	height = iImageSize.height();
}

///////////////////////////////////////////////////////////////////////////////
}
} // namespace
