###############################################################################
# Copyright (C) 2012 by
#   MetraLabs GmbH (MLAB), GERMANY
# and
#   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
# All rights reserved.
#
# Contact: info@mira-project.org
#
# Commercial Usage:
#   Licensees holding valid commercial licenses may use this file in
#   accordance with the commercial license agreement provided with the
#   software or, alternatively, in accordance with the terms contained in
#   a written agreement between you and MLAB or NICR.
#
# GNU General Public License Usage:
#   Alternatively, this file may be used under the terms of the GNU
#   General Public License version 3.0 as published by the Free Software
#   Foundation and appearing in the file LICENSE.GPL3 included in the
#   packaging of this file. Please review the following information to
#   ensure the GNU General Public License version 3.0 requirements will be
#   met: http://www.gnu.org/copyleft/gpl.html.
#   Alternatively you may (at your option) use any later version of the GNU
#   General Public License if such license has been publicly approved by
#   MLAB and NICR (or its successors, if any).
#
# IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
# INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
# THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
# "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
# BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
# FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
# ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
# PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
#
###############################################################################
#
# Provides the functionality for the "in source" Makefiles that are generated 
# in each source subdirectory.
#
# author: Erik Einhorn
#
###############################################################################
# Default target executed when no arguments are given to make.

default_target: debug
.PHONY : default_target

###############################################################################

REL_DIR=`cmake -DSRC=$(TOP_DIR) -DDEST=$(CURDIR) -P $(MIRA_MAKE_DIR)/Relpath.cmake`

###############################################################################
# the directories for the build-configurations (debug, release, test)

BUILD=build

BUILD_DEBUG=$(BUILD)/debug
BUILD_RELEASE=$(BUILD)/release
BUILD_RELWITHDEBINFO=$(BUILD)/relwithdebinfo
BUILD_COVERAGE=$(BUILD)/coverage
BUILD_MANIFEST=$(BUILD)/manifest

###############################################################################
# set make to silent mode by default but allow to pass VERBOSE flag

VERB_FLAGS=-s
ifdef VERBOSE
VERB_FLAGS=VERBOSE=1
endif

###############################################################################
# set cmake toolchain file if requested

TOOLCHAIN_FILE=
ifdef TOOLCHAIN
TOOLCHAIN_FILE=-DCMAKE_TOOLCHAIN_FILE=$(TOOLCHAIN)
endif

###############################################################################
# Select the right makefile generator for cmake

OSTYPE := $(shell echo "$$OSTYPE")

ifeq ($(OSTYPE),cygwin)
	CMAKE_GENERATOR=	-G"Unix Makefiles"
else
	CMAKE_GENERATOR=
endif

###############################################################################
# these targets will be process in the "all other targets"-branch below

all:
clean:

###############################################################################
# Targets for preparing the build directory

$(TOP_DIR)/$(BUILD):
	@mkdir -p $(TOP_DIR)/$(BUILD)


$(TOP_DIR)/$(BUILD_DEBUG)/Makefile:
	@echo "******************************"
	@echo "*** PREPARING DEBUG BUILD  ***"
	@echo "******************************"
	@rm -rf CMakeFiles    # remove created cmake files, if someone has accidentally called cmake .
	@rm -f CMakeCache.txt
	@mkdir -p $(TOP_DIR)/$(BUILD_DEBUG)
	@cd $(TOP_DIR)/$(BUILD_DEBUG) && cmake $(CMAKE_GENERATOR) -DCMAKE_BUILD_TYPE=Debug $(TOOLCHAIN_FILE) ../..
	
$(TOP_DIR)/$(BUILD_RELEASE)/Makefile:
	@echo "*******************************"
	@echo "*** PREPARING RELEASE BUILD ***"
	@echo "*******************************"
	@rm -rf CMakeFiles   # remove created cmake files, if someone has accidentally called cmake .
	@rm -f CMakeCache.txt
	@mkdir -p $(TOP_DIR)/$(BUILD_RELEASE)
	@cd $(TOP_DIR)/$(BUILD_RELEASE) && cmake $(CMAKE_GENERATOR) -DCMAKE_BUILD_TYPE=Release $(TOOLCHAIN_FILE) ../..

$(TOP_DIR)/$(BUILD_RELWITHDEBINFO)/Makefile:
	@echo "**************************************************"
	@echo "*** PREPARING RELEASE WITH DEBUG SYMBOLS BUILD ***"
	@echo "**************************************************"
	@rm -rf CMakeFiles   # remove created cmake files, if someone has accidentally called cmake .
	@rm -f CMakeCache.txt
	@mkdir -p $(TOP_DIR)/$(BUILD_RELWITHDEBINFO)
	@cd $(TOP_DIR)/$(BUILD_RELWITHDEBINFO) && cmake $(CMAKE_GENERATOR) -DCMAKE_BUILD_TYPE=RelWithDebInfo $(TOOLCHAIN_FILE) ../..
	
	
	
$(TOP_DIR)/$(BUILD_DEBUG)/TestMakefile:
	@echo "**************************************"
	@echo "***  PREPARING TEST BUILD (Debug)  ***"
	@echo "**************************************"
	@rm -rf CMakeFiles   # remove created cmake files, if someone has accidentally called cmake .
	@rm -f CMakeCache.txt
	@mkdir -p $(TOP_DIR)/$(BUILD_DEBUG)
	@cd $(TOP_DIR)/$(BUILD_DEBUG) && cmake $(CMAKE_GENERATOR) -DCMAKE_BUILD_TYPE=Debug -DMIRA_BUILD_TESTS=1 $(TOOLCHAIN_FILE) ../..
	
$(TOP_DIR)/$(BUILD_RELEASE)/TestMakefile:
	@echo "****************************************"
	@echo "***  PREPARING TEST BUILD (Release)  ***"
	@echo "****************************************"
	@rm -rf CMakeFiles   # remove created cmake files, if someone has accidentally called cmake .
	@rm -f CMakeCache.txt
	@mkdir -p $(TOP_DIR)/$(BUILD_RELEASE)
	@cd $(TOP_DIR)/$(BUILD_RELEASE) && cmake $(CMAKE_GENERATOR) -DCMAKE_BUILD_TYPE=Release -DMIRA_BUILD_TESTS=1 $(TOOLCHAIN_FILE) ../..
	
$(TOP_DIR)/$(BUILD_RELWITHDEBINFO)/TestMakefile:
	@echo "**********************************************************"
	@echo "***  PREPARING TEST BUILD (Release with Debug Symbols) ***"
	@echo "**********************************************************"
	@rm -rf CMakeFiles   # remove created cmake files, if someone has accidentally called cmake .
	@rm -f CMakeCache.txt
	@mkdir -p $(TOP_DIR)/$(BUILD_RELWITHDEBINFO)
	@cd $(TOP_DIR)/$(BUILD_RELWITHDEBINFO) && cmake $(CMAKE_GENERATOR) -DCMAKE_BUILD_TYPE=RelWithDebInfo -DMIRA_BUILD_TESTS=1 $(TOOLCHAIN_FILE) ../..
	
	
	
$(TOP_DIR)/$(BUILD_DEBUG)/ExamplesMakefile:
	@echo "******************************************"
	@echo "***  PREPARING EXAMPLES BUILD (Debug)  ***"
	@echo "******************************************"
	@rm -rf CMakeFiles   # remove created cmake files, if someone has accidentally called cmake .
	@rm -f CMakeCache.txt
	@mkdir -p $(TOP_DIR)/$(BUILD_DEBUG)
	@cd $(TOP_DIR)/$(BUILD_DEBUG) && cmake $(CMAKE_GENERATOR) -DCMAKE_BUILD_TYPE=Debug -DMIRA_BUILD_EXAMPLES=1 $(TOOLCHAIN_FILE) ../..
	
$(TOP_DIR)/$(BUILD_RELEASE)/ExamplesMakefile:
	@echo "********************************************"
	@echo "***  PREPARING EXAMPLES BUILD (Release)  ***"
	@echo "********************************************"
	@rm -rf CMakeFiles   # remove created cmake files, if someone has accidentally called cmake .
	@rm -f CMakeCache.txt
	@mkdir -p $(TOP_DIR)/$(BUILD_RELEASE)
	@cd $(TOP_DIR)/$(BUILD_RELEASE) && cmake $(CMAKE_GENERATOR) -DCMAKE_BUILD_TYPE=Release -DMIRA_BUILD_EXAMPLES=1 $(TOOLCHAIN_FILE) ../..
	
$(TOP_DIR)/$(BUILD_RELWITHDEBINFO)/ExamplesMakefile:
	@echo "**************************************************************"
	@echo "***  PREPARING EXAMPLES BUILD (Release with Debug Symbols) ***"
	@echo "**************************************************************"
	@rm -rf CMakeFiles   # remove created cmake files, if someone has accidentally called cmake .
	@rm -f CMakeCache.txt
	@mkdir -p $(TOP_DIR)/$(BUILD_RELWITHDEBINFO)
	@cd $(TOP_DIR)/$(BUILD_RELWITHDEBINFO) && cmake $(CMAKE_GENERATOR) -DCMAKE_BUILD_TYPE=RelWithDebInfo -DMIRA_BUILD_EXAMPLES=1 $(TOOLCHAIN_FILE) ../..
	
	
	
$(TOP_DIR)/$(BUILD_COVERAGE)/Makefile:
	@echo "**********************************"
	@echo "***  PREPARING COVERAGE BUILD  ***"
	@echo "**********************************"
	@rm -rf CMakeFiles   # remove created cmake files, if someone has accidentally called cmake .
	@rm -f CMakeCache.txt
	@mkdir -p $(TOP_DIR)/$(BUILD_COVERAGE)
	@cd $(TOP_DIR)/$(BUILD_COVERAGE) && cmake $(CMAKE_GENERATOR) -DCMAKE_BUILD_TYPE=Debug -DMIRA_BUILD_EXAMPLES=1 -DMIRA_BUILD_TESTS=1 -DGENERATE_COVERAGE_FILES=1 $(TOOLCHAIN_FILE) ../..


$(TOP_DIR)/$(BUILD_MANIFEST)/Makefile:
	@echo "***************************************"
	@echo "***  PREPARING MANIFEST ONLY BUILD  ***"
	@echo "***************************************"
	@rm -rf CMakeFiles   # remove created cmake files, if someone has accidentally called cmake .
	@rm -f CMakeCache.txt
	@mkdir -p $(TOP_DIR)/$(BUILD_MANIFEST)
	@cd $(TOP_DIR)/$(BUILD_MANIFEST) && cmake $(CMAKE_GENERATOR) -DCMAKE_BUILD_TYPE=Debug -DMIRA_GEN_MANIFESTS_ONLY=1 --no-warn-unused-cli ../..

###############################################################################
# Targets for building everything in one of our configurations 

debug: $(TOP_DIR)/$(BUILD_DEBUG)/Makefile
	@cd $(TOP_DIR)/$(BUILD_DEBUG)/$(REL_DIR) && $(MAKE) ${VERB_FLAGS}
	
release: $(TOP_DIR)/$(BUILD_RELEASE)/Makefile
	@cd $(TOP_DIR)/$(BUILD_RELEASE)/$(REL_DIR) && $(MAKE) ${VERB_FLAGS}

relwithdebinfo: $(TOP_DIR)/$(BUILD_RELWITHDEBINFO)/Makefile
	@cd $(TOP_DIR)/$(BUILD_RELWITHDEBINFO)/$(REL_DIR) && $(MAKE) ${VERB_FLAGS}


test: $(TOP_DIR)/$(BUILD_DEBUG)/TestMakefile
	@export PATH="$(PATH):$(TOP_DIR)/$(BUILD_DEBUG)/base" && \
	cd $(TOP_DIR)/$(BUILD_DEBUG)/$(REL_DIR) && $(MAKE) ${VERB_FLAGS} && $(MAKE) ${VERB_FLAGS} test
	
test_release: $(TOP_DIR)/$(BUILD_RELEASE)/TestMakefile
	@export PATH="$(PATH):$(TOP_DIR)/$(BUILD_RELEASE)/base" && \
	cd $(TOP_DIR)/$(BUILD_RELEASE)/$(REL_DIR) && $(MAKE) ${VERB_FLAGS} && $(MAKE) ${VERB_FLAGS} test
	
test_relwithdebinfo: $(TOP_DIR)/$(BUILD_RELWITHDEBINFO)/TestMakefile
	@export PATH="$(PATH):$(TOP_DIR)/$(BUILD_RELWITHDEBINFO)/base" && \
	cd $(TOP_DIR)/$(BUILD_RELWITHDEBINFO)/$(REL_DIR) && $(MAKE) ${VERB_FLAGS} && $(MAKE) ${VERB_FLAGS} test


examples: $(TOP_DIR)/$(BUILD_DEBUG)/ExamplesMakefile
	cd $(TOP_DIR)/$(BUILD_DEBUG)/$(REL_DIR) && $(MAKE) ${VERB_FLAGS}
	
examples_release: $(TOP_DIR)/$(BUILD_RELEASE)/ExamplesMakefile
	cd $(TOP_DIR)/$(BUILD_RELEASE)/$(REL_DIR) && $(MAKE) ${VERB_FLAGS}

examples_relwithdebinfo: $(TOP_DIR)/$(BUILD_RELWITHDEBINFO)/ExamplesMakefile
	cd $(TOP_DIR)/$(BUILD_RELWITHDEBINFO)/$(REL_DIR) && $(MAKE) ${VERB_FLAGS}


coverage: $(TOP_DIR)/$(BUILD_COVERAGE)/Makefile
	@cd $(TOP_DIR)/$(BUILD_COVERAGE)/$(REL_DIR) && $(MAKE) ${VERB_FLAGS}
	
	
manifest: $(TOP_DIR)/$(BUILD_MANIFEST)/Makefile
	@mkdir -p lib
	@cd $(TOP_DIR)/$(BUILD_MANIFEST)/$(REL_DIR) && $(MAKE) ${VERB_FLAGS} manifest

install: $(TOP_DIR)/$(BUILD_DEBUG)/Makefile
ifdef DESTDIR
	@cd $(TOP_DIR)/$(BUILD_DEBUG)/$(REL_DIR) && $(MAKE) ${VERB_FLAGS} install
else
	@echo "ERROR: Please provide DESTDIR for installation"
endif

install_release: $(TOP_DIR)/$(BUILD_RELEASE)/Makefile
ifdef DESTDIR
	@cd $(TOP_DIR)/$(BUILD_RELEASE)/$(REL_DIR) && $(MAKE) ${VERB_FLAGS} install
else
	@echo "ERROR: Please provide DESTDIR for installation"
endif


.PHONY: doc
doc: $(TOP_DIR)/$(BUILD_DEBUG)/Makefile
	@cd $(TOP_DIR)/$(BUILD_DEBUG)/$(REL_DIR) && $(MAKE) ${VERB_FLAGS} doc

###############################################################################
# Targets for building a special subtarget in one of our configurations 
# (debug,release; test is not necessary here)

%_install_debug: $(TOP_DIR)/$(BUILD_DEBUG)/Makefile
ifdef DESTDIR
	cmake -DPackage=$* -DTopDir=$(TOP_DIR) -DDestDir=$(DESTDIR) -DTarget=debug -P ${MIRA_MAKE_DIR}/InstallPackage.cmake
else
	@echo "ERROR: Please provide DESTDIR for installation"
endif

%_install_release: $(TOP_DIR)/$(BUILD_RELEASE)/Makefile
ifdef DESTDIR
	cmake -DPackage=$* -DTopDir=$(TOP_DIR) -DDestDir=$(DESTDIR) -DTarget=release -P ${MIRA_MAKE_DIR}/InstallPackage.cmake
else
	@echo "ERROR: Please provide DESTDIR for installation"
endif

%_debug: $(TOP_DIR)/$(BUILD_DEBUG)/Makefile
	@cd $(TOP_DIR)/$(BUILD_DEBUG)/$(REL_DIR) && $(MAKE) ${VERB_FLAGS} $*

%_release: $(TOP_DIR)/$(BUILD_RELEASE)/Makefile
	@cd $(TOP_DIR)/$(BUILD_RELEASE)/$(REL_DIR) && $(MAKE) ${VERB_FLAGS} $*

%_relwithdebinfo: $(TOP_DIR)/$(BUILD_RELWITHDEBINFO)/Makefile
	@cd $(TOP_DIR)/$(BUILD_RELWITHDEBINFO)/$(REL_DIR) && $(MAKE) ${VERB_FLAGS} $*

###############################################################################
# catch these two Makefile-specific targets instead of processing them
# in the "all other targets"-branch below

%Insource.make:
	@echo "Insource.make, nothing to do"

Makefile:
	@echo "Makefile, nothing to do"

###############################################################################
# "all other targets"-branch: do debug build by default
# and deligate the target to the main debug-Makefile

%: $(TOP_DIR)/$(BUILD_DEBUG)
	@cd $(TOP_DIR)/$(BUILD_DEBUG)/$(REL_DIR) && $(MAKE) ${VERB_FLAGS} $*
