/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file PropertyEditorTest.C
 *    Manual test for testing the property editor.
 *
 * @author Erik Einhorn
 * @date   2011/09/11
 */

#include <QApplication>

#include <widgets/PropertyEditor.h>
#include <serialization/adapters/std/vector>
#include <serialization/adapters/std/map>
#include <serialization/adapters/Eigen/Eigen>

///////////////////////////////////////////////////////////////////////////////

class MyClass
{
public:

	MyClass() {}
	MyClass(int A, float F, const std::string& Str) :
		a(A), b(A), boolean(true), f(F), str(Str), enumeration(VALUE1),
		rdonlyString("This is a read-only string, that cannot be altered"){}

	template<typename Reflector>
	void reflect(Reflector& r)
	{
		r.property("A",a, "An int");
		r.property("B",b, "Another int", mira::PropertyHints::slider(-5,5,1));
		r.property("Bool", boolean, "a bool");
		r.property("F",f, "A float", mira::PropertyHints::limits(-5,5));
		r.property("Str",str, "A string");
		r.property("Matrix",matrix, "An eigen matrix");
		r.property("Enum",enumeration, "An enumeration", mira::PropertyHints::enumeration("Value1;Value2;Value3"));
		r.roproperty("RdOnly", rdonlyString, "A read-only string");
	}

	enum MyEnum {
		VALUE1,
		VALUE2,
		VALUE3
	};

	int a;
	int b;
	bool boolean;
	float f;
	std::string str;
	Eigen::Matrix3f matrix;
	int enumeration;
	std::string rdonlyString;
};

///////////////////////////////////////////////////////////////////////////////

class MyClass2
{
public:

	MyClass2()
	{
		objects.push_back(new MyClass(1,1.234f,"First"));
		objects.push_back(new MyClass(2,2.345f,"Second"));
		objects.push_back(new MyClass(3,3.456f,"Third"));

		mappedObjects.insert(std::make_pair("Key1", MyClass(5,111.222f, "Mapped1")));
		mappedObjects.insert(std::make_pair("Key2", MyClass(7,333.444f, "Mapped2")));
	}

	template<typename Reflector>
	void reflect(Reflector& r)
	{
		r.property("Objects",objects, "A vector of objects");
		r.property("MappedObjects",mappedObjects, "A map of objects");
	}

	std::vector<MyClass*> objects;
	std::map<std::string, MyClass> mappedObjects;

};

///////////////////////////////////////////////////////////////////////////////

using namespace mira;
int main(int argc, char** argv)
{
	QApplication qapp(argc,argv);

	MyClass2 myObject;

	PropertyManager m;
	m.addObject("myObject", myObject);

	PropertyEditor* e = new PropertyEditor;
	e->installFilterShortCut(e);
	e->setAutoHideFilterBar(true);
	e->addProperty(m.getPropertyNode("myObject"));

	e->show();

	return qapp.exec();
}
