/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file PropertyEditorCommonDelegates.h
 *    Implementation of PropertyEditorCommonDelegates.
 *
 * @author Erik Einhorn
 * @date   2010/12/14
 */

#ifndef _MIRA_PROPERTYEDITORCOMMONDELEGATES_H_
#define _MIRA_PROPERTYEDITORCOMMONDELEGATES_H_

#include <QSlider>
#include <QSpinBox>
#include <QComboBox>
#include <QDoubleSpinBox>
#include <QLineEdit>
#include <QCheckBox>

#include <serialization/PropertySerializer.h>

#include <widgets/GuiWidgetsExports.h>

namespace mira {

///////////////////////////////////////////////////////////////////////////////

class PropertyNode;

class PropertyDelegate_Slider : public QSlider
{
	Q_OBJECT
public:
	PropertyDelegate_Slider(PropertyNode* p, QWidget* parent);
public slots:
	void slotSetValue(int value);
public:
	PropertyNode* property;
};

///////////////////////////////////////////////////////////////////////////////

class SpinBoxSmartScroll
{
public:
	SpinBoxSmartScroll();
	void handleEventFilter(QEvent* event);
	double handleWheelEvent(QWheelEvent* event, QLineEdit* lineEdit, QChar decimalPoint, double defaultStep);
	void highlightScrolledDigit(QLineEdit* lineEdit, QChar decimalPoint);
	int scrolledDigit() const;
private:
	bool mMouseMovedSinceLastScroll;
	// <0 for digits behind decimal dot, >=0 for digits in front of decimal point, ==0, if no scrolled digit
	int mScrolledDigit;
	double mToAdd;
};

///////////////////////////////////////////////////////////////////////////////

class MIRA_GUI_WIDGETS_EXPORT PropertyDelegate_SpinBox : public QSpinBox, private SpinBoxSmartScroll
{
	Q_OBJECT
public:
	PropertyDelegate_SpinBox(PropertyNode* p, QWidget* parent);
public slots:
	void slotSetValue(int value);
public:
	PropertyNode* property;
private:
	void wheelEvent(QWheelEvent* event);
protected:
	bool eventFilter(QObject* obj, QEvent* event);
};

///////////////////////////////////////////////////////////////////////////////

class PropertyDelegate_DoubleSlider : public QSlider
{
	Q_OBJECT
public:
	PropertyDelegate_DoubleSlider(PropertyNode* p, QWidget* parent);
public slots:
	void slotSetValue(int value);
public:
	PropertyNode* property;
private:
	double mMinimum;
	double mMaximum;
	double mStep;
};

///////////////////////////////////////////////////////////////////////////////

class PropertyDelegate_DoubleSpinBox : public QDoubleSpinBox, private SpinBoxSmartScroll
{
	Q_OBJECT
public:
	PropertyDelegate_DoubleSpinBox(PropertyNode* p, QWidget* parent);
	QString textFromValue(double value) const;
	double valueFromText(const QString& text) const;
public slots:
	void slotSetValue(double value);
public:
	PropertyNode* property;
	int precision;
	QLocale locale;
private:
	void wheelEvent(QWheelEvent* event);
protected:
	bool eventFilter(QObject* obj, QEvent* event);
};

///////////////////////////////////////////////////////////////////////////////

class PropertyDelegate_ComboBox : public QComboBox
{
	Q_OBJECT
public:
	PropertyDelegate_ComboBox(PropertyNode* p, QWidget* parent);
public slots:
	void slotSetValue(int value);
public:
	PropertyNode* property;
};

///////////////////////////////////////////////////////////////////////////////

class PropertyDelegate_LineEdit : public QLineEdit
{
	Q_OBJECT
public:
	PropertyDelegate_LineEdit(PropertyNode* p, QWidget* parent);
public slots:
	void slotSetValue();
public:
	PropertyNode* property;
};

///////////////////////////////////////////////////////////////////////////////

class PropertyDelegate_CheckBox : public QCheckBox
{
	Q_OBJECT
public:
	PropertyDelegate_CheckBox(PropertyNode* p, QWidget* parent);
public slots:
	void slotSetValue(bool value);
public:
	TypedPropertyNode<bool>* property;
};

///////////////////////////////////////////////////////////////////////////////

}

#endif
