/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file VisualizationTool2D.C
 *    Implementation of VisualizationTool2D.
 *
 * @author Tim Langner
 * @date   2013/07/08
 */

#include <visualization/VisualizationTool2D.h>

#include <QGraphicsItem>

namespace mira {

///////////////////////////////////////////////////////////////////////////////

VisualizationTool2D::VisualizationTool2D() :
	mItem(NULL),
	mSite(NULL)
{
}

VisualizationTool2D::~VisualizationTool2D() {
	delete mItem;
}

void VisualizationTool2D::init(IVisualizationSite* site)
{
	VisualizationTool::init(site);
	mSite = dynamic_cast<IVisualization2DSite*>(site);
	assert(mSite!=NULL);
	setupScene(mSite);
}

IVisualization2DSite* VisualizationTool2D::getSite()
{
	return mSite;
}

void VisualizationTool2D::activate()
{
	if (mItem != NULL)
		mItem->setVisible(true);
	// try to get transform here throws an exception if there is no one available
	// this will inform the user once upon activation as we catch and ignore it in update()
	getTransform<RigidTransform2f>(
			getSite()->getFixedFrame(), getSite()->getCameraFrame(), Time::now());
}

void VisualizationTool2D::deactivate()
{
	if (mItem != NULL)
		mItem->setVisible(false);
}


void VisualizationTool2D::update(Duration dt)
{
	try
	{
		mTransform = getTransform<RigidTransform2f>(
			getSite()->getFixedFrame(), getSite()->getCameraFrame(), Time::now());

		if (mItem != NULL)
			QtUtils::setTransform(mItem, mTransform);
	}
	catch(Exception&)
	{
		// ignore
	}
}


///////////////////////////////////////////////////////////////////////////////

}

MIRA_CLASS_SERIALIZATION(mira::VisualizationTool2D, mira::VisualizationTool)
