/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file LineEditTextFormat.h
 *    TODO Add description.
 *
 * @author erik
 * @date   15.12.2014
 */

#ifndef _MIRA_LINEEDITTEXTFORMAT_H_
#define _MIRA_LINEEDITTEXTFORMAT_H_

#include <QList>
#include <QCoreApplication>
#include <QTextLayout>
#include <QLineEdit>

namespace mira {

///////////////////////////////////////////////////////////////////////////////

// source: http://sugarrushva.my03.com/219849-how-can-i-change-color-of-part-of-the-text-in-qlineedit.html
/**
 * Allows to format the text of a QLineEdit.
 *
 * Usage example:
 * \code
 *     QList<QTextLayout::FormatRange> formats;
 *     QTextCharFormat f;
 *     f.setFontWeight(QFont::Bold);
 *     QTextLayout::FormatRange fr;
 *     fr.start = 3;
 *     fr.length = 4;
 *     fr.format = f;
 *     formats.append(fr);
 *     setLineEditTextFormat(lineEdit, formats);
 * \endcode
 */
inline void setLineEditTextFormat(QLineEdit* lineEdit, const QList<QTextLayout::FormatRange>& formats)
{
	if(!lineEdit)
		return;
	QList<QInputMethodEvent::Attribute> attributes;
	foreach(const QTextLayout::FormatRange& fr, formats)
	{
		QInputMethodEvent::AttributeType type = QInputMethodEvent::TextFormat;
		int start = fr.start - lineEdit->cursorPosition();
		int length = fr.length;
		QVariant value = fr.format;
		attributes.append(QInputMethodEvent::Attribute(type, start, length, value));
	}
	QInputMethodEvent event(QString(), attributes);
	QCoreApplication::sendEvent(lineEdit, &event);
}

/**
 * Removes all formatting instructions, set by the above method.
 */
inline void clearLineEditTextFormat(QLineEdit* lineEdit)
{
	setLineEditTextFormat(lineEdit, QList<QTextLayout::FormatRange>());
}


///////////////////////////////////////////////////////////////////////////////

} // namespace

#endif
