/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file CovObject.h
 *    Visualization of covariances.
 *
 * @author Erik Einhorn
 * @date   08/21/2011
 */

#ifndef _MIRA_COVOBJECT_H_
#define _MIRA_COVOBJECT_H_

#include <visualization/3d/MeshObject.h>

namespace mira {

///////////////////////////////////////////////////////////////////////////////

/**
 * Visualization of covariances.
 */
class MIRA_GUI_VISUALIZATION_EXPORT CovObject : public MeshObject
{

public:
	/**
	 * Creates a new CovObject that can be used to display a position
	 * covariance ellipsoid in 3D.
	 */
	CovObject(Ogre::SceneManager* sceneManager, Ogre::SceneNode* parent=NULL);

public:

	void setSigma(float sigma);
	float getSigma() const {return mSigma;}

public:


	void setMean(const Eigen::Vector2f& x);
	void setMean(const Eigen::Vector3f& x);

	void setCovariance(const Eigen::Matrix2f& cov);
	void setCovariance(const Eigen::Matrix3f& cov);


private:

	float mSigma;

	Eigen::Vector3f mW; // the singular values
};

///////////////////////////////////////////////////////////////////////////////

}

#endif
