/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

#include <serialization/adapters/std/vector>

#include <fw/Unit.h>

#include "../PerfStats.h"

using namespace std;
using namespace mira;


#define D 500

class BenchmarkRPCSelf : public Unit
{
	MIRA_OBJECT(BenchmarkRPCSelf)
public:
	BenchmarkRPCSelf() :
		Unit(Duration::milliseconds(D))	{
		count=0;
	}

	~BenchmarkRPCSelf() {
		float avg_us = (float)(total / count).totalMicroseconds();
		std::cout << "RPC average: " << std::endl;
		std::cout << (avg_us) / 1000.0f << endl;
	}

	virtual void initialize() {
		publishService(*this);
	}

	template<typename Reflector>
	void reflect(Reflector& r)
	{
		Unit::reflect(r);
		r.method("foo",  &BenchmarkRPCSelf::foo, this, "");
		r.member("N", N, "DataSize");
	}

	virtual void process()
	{
		const int repeat = 1000;
		Time start;
		Duration d;

		std::vector<uint8> vec;
		vec.resize(N*1024);

		start = Time::now();
		for(int i=0; i<repeat; ++i)
		{
			RPCFuture<void> r2 = callService<void>(this->getGlobalID(),"foo", vec);
			r2.get();
		}
		d = Time::now() - start;
		std::cout << "rpc took: " << d/repeat << std::endl;

		total+=d;
		count+=repeat;
	}


	void foo(const std::vector<uint8>& vec) {}

	int count;
	Duration total;
	int N;
};

MIRA_CLASS_SERIALIZATION( BenchmarkRPCSelf, Unit );




class BenchmarkRPCCaller : public Unit
{
	MIRA_OBJECT(BenchmarkRPCCaller)
public:
	BenchmarkRPCCaller() :
		Unit(Duration::milliseconds(D))	{
		count = 0;
	}

	~BenchmarkRPCCaller() {
		float avg_us = (float)(total / count).totalMicroseconds();
		std::cout << "RPC average: " << std::endl;
		std::cout << (avg_us) / 1000.0f << endl;
	}

	template<typename Reflector>
	void reflect(Reflector& r)
	{
		Unit::reflect(r);
		r.member("N", N, "DataSize");
	}

	virtual void process()
	{
		const int repeat = 1000;
		Time start;
		Duration d;

		std::vector<uint8> vec;
		vec.resize(N*1024);

		start = Time::now();
		for(int i=0; i<repeat; ++i)
		{
			RPCFuture<void> r2 = callService<void>("Service","foo", vec);
			r2.get();
		}
		d = Time::now() - start;
		std::cout << "rpc took: " << d/repeat << std::endl;

		total+=d;
		count+=repeat;
	}


	int count;
	Duration total;
	int N;
};

MIRA_CLASS_SERIALIZATION( BenchmarkRPCCaller, Unit );



class BenchmarkRPCService : public MicroUnit
{
	MIRA_OBJECT(BenchmarkRPCService)
public:
	BenchmarkRPCService() {}

	virtual void initialize()
	{
		publishService(*this);
	}

	template<typename Reflector>
	void reflect(Reflector& r)
	{
		MicroUnit::reflect(r);
		r.method("foo",  &BenchmarkRPCService::foo, this, "");
	}

	void foo(const std::vector<uint8>& vec) {}

};

MIRA_CLASS_SERIALIZATION( BenchmarkRPCService, MicroUnit );
