/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

#ifndef _MIRA_BENCHMARKSTATS_H_
#define _MIRA_BENCHMARKSTATS_H_

#include <stdint.h>
#include <math.h>

#include "PerfStats.h"

class BenchmarkStats
{
public:

	BenchmarkStats(const std::string& _name) : name(_name)
	{
		n=0;
		start=0;
		mean=0.0;
		M=0.0;
		total=0;
	}

	~BenchmarkStats() {
		showStats();
	}

	// start timing and return start time (in cylces)
	uint64_t tic()
	{
		start = getCycleCount();
		return start;
	}

	/**
	 * stop a timing run, that started with the specified start time.
	 * Average and variance of timing results will be adapted instantly.
	 */
	void toc(uint64_t s)
	{
		uint64_t d = getCycleCount() - s;

		++n;
		double alpha = d-mean;
		mean += alpha / n;
		M += (alpha)*(d-mean);
		total += d;

		std::cout << name << ": " << d << std::endl;

		if(n%100==0)
			showStats();
	}

	void toc()
	{
		toc(start);
	}


	void showStats()
	{
		double var = M/n;

		std::cout << "Stats for: " << name
		          << ", Average: " << mean << " (" << total/n << ")"
		          << ", Std.dev: " << sqrt(M/n) << std::endl;
	}

private:

	std::string name;

	unsigned int n;
	uint64_t start;
	uint64_t total;

	double mean;
	double M;
};



#endif
