/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file TimeTest.C
 *    Test cases for Time.h.
 *
 * @author Tim Langner
 * @date   2010/10/06
 */

#include <boost/test/unit_test.hpp>

#include <utils/Time.h>
#include <serialization/XMLSerializer.h>

using namespace mira;

BOOST_AUTO_TEST_CASE( testUnix )
{
	Time to(Date(1970, Jan, 1), Duration(0, 0, 0));
	BOOST_CHECK_EQUAL(to.toUnixNS(), 0);

	Time from = Time::fromUnixNS(0);
	BOOST_CHECK_EQUAL(from, Time(Date(1970, Jan, 1), Duration(0, 0, 0)));
}

BOOST_AUTO_TEST_CASE( testSerialization )
{
	XMLDom xml;
	XMLSerializer s(xml);

	Time time = Time::now();
	s.serialize("time", time, "");

	Duration duration = Duration::seconds(3);
	s.serialize("duration", duration, "");

	Date date(1970, Jan, 1);
	s.serialize("date", date, "");


	XMLDeserializer ds(xml);

	Time time2;
	ds.deserialize("time", time2);
	BOOST_CHECK_EQUAL(time, time2);

	Duration duration2;
	ds.deserialize("duration", duration2);
	BOOST_CHECK_EQUAL(duration, duration2);

	Date date2;
	ds.deserialize("date", date2);
	BOOST_CHECK_EQUAL(date, date2);

}
