/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file JSONTest.C
 *    Test case for JSON.h.
 *
 * @author Tim Langner
 * @date   2012/04/02
 */

#include <boost/test/unit_test.hpp>

#include <json/JSON.h>
#include <serialization/BinarySerializer.h>
#include <serialization/Print.h>

using namespace mira;

BOOST_AUTO_TEST_CASE( JSONSerializeTest )
{
	json::Value v1 = json::Object();
	v1.get_obj()["Float"] = json::Value(3.0f);
	v1.get_obj()["String"] = json::Value("Hello");
	v1.get_obj()["Int"] = json::Value(2000);

	BinaryBufferOstream::buffer_type s;
	BinaryBufferSerializer bs(&s);
	bs.serialize(v1);

	json::Value v2;
	BinaryBufferDeserializer ds(&s);
	ds.deserialize(v2);

	BOOST_CHECK(v2.type() == json_spirit::obj_type);
	BOOST_CHECK_CLOSE(v2.get_obj()["Float"].get_real(), 3.0f, 0.0001f);
	BOOST_CHECK(v2.get_obj()["String"].get_str() == "Hello");
	BOOST_CHECK(v2.get_obj()["Int"].get_int() == 2000);
}
