/*
 * Copyright (C) 2015 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file $NAME$.C
 *    $DESCRIPTION$
 *
 * @author $AUTHOR$
 * @date   $DATE$
 */

#include <visualization/Visualization2DBasic.h>

#include <QGraphicsItem>

using namespace mira;

$NAMEPSACE_BEGIN$

///////////////////////////////////////////////////////////////////////////////

/**
 * $DESCRIPTION$
 */
class $NAME$ : public Visualization2DBasic<The_Type_You_Want_to_Visualize>
{
MIRA_META_OBJECT($NAME$, // TODO: add correct name, category and description
			("Name", "Visualization")
			("Category", "Geomtery")
			("Description", "Visualizes ..."))

	typedef The_Type_You_Want_to_Visualize Type;
	typedef Visualization2DBasic<Type> Base;

public:

	$NAME$();

	template<typename Reflector>
	void reflect(Reflector& r)
	{
		Base::reflect(r);

		// TODO: reflect all parameters (members and properties) that specify the persistent state of the unit
		//r.property("Param1", mParam1, "First parameter of this unit with default value", 123.4f);
		//r.member("Param2", mParam2, setter(&UnitName::setParam2,this), "Second parameter with setter");
	}


	virtual QGraphicsItem* setupScene(QGraphicsScene* scene);

protected:

	virtual void dataChanged(ChannelRead<Type> data);

};

///////////////////////////////////////////////////////////////////////////////

$NAME$::$NAME$() : Base("DisplayedName") // TODO: << enter the name that should be shown in the visualization control
{
	// contructor
}

QGraphicsItem* $NAME$::setupScene(QGraphicsScene* scene)
{
	// TODO: create your visual objects using QGraphicsScene

	QGraphicsEllipseItem* ellipse = new QGraphicsEllipseItem();
	ellipse->setRect(-0.5, -0.5, 1.0, 1.0);
	scene->addItem(ellipse);

	return ellipse;
}

void $NAME$::dataChanged(ChannelRead<Type> data)
{
	// TODO: is called whenever the data has changed
}

///////////////////////////////////////////////////////////////////////////////

$NAMEPSACE_END$

MIRA_CLASS_SERIALIZATION($NAMESPACE$::$NAME$, mira::Visualization2D );
