/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file TapePlayerView.h
 *    A view for playing back tape files.
 *
 * @author Tim Langner
 * @date   2011/01/12
 */

#ifndef _MIRA_TAPEPLAYERVIEW_H_
#define _MIRA_TAPEPLAYERVIEW_H_

#include <rcp/ViewPart.h>
#include <rcp/PartListener.h>

#include <serialization/GetterSetter.h>

namespace mira {

///////////////////////////////////////////////////////////////////////////////

class TapePlayerWidget;

//////////////////////////////////////////////////////////////////////////////

class TapePlayerView : public ViewPart
{
MIRA_META_OBJECT(TapePlayerView,
				("Category", "Tape")
				("Name", "Player")
				("Description", "Allows playback of tape files"))
Q_OBJECT

public:

	TapePlayerView();
	virtual ~TapePlayerView();
	
	template <typename Reflector>
	void reflect(Reflector& r)
	{
		ViewPart::reflect(r);
		r.member("LastTapes", mLastTapes, "Last opened tapes");
		r.member("UseOriginalTimestamp", mUseOriginalTimestamp, "Use the timestamp from file");
		r.member("NamespacePrefix", mNamespacePrefix, "The namespace prefix for opened tapes", "");
		r.member("LastChannelsToPlay",
			getter(&TapePlayerView::getLastChannelsToPlay, this),
			setter(&TapePlayerView::setLastChannelsToPlay, this),
			"Selected channels to play", boost::optional<std::vector<std::string>>());
	}

	virtual Qt::DockWidgetArea getDefaultDockArea() const {
		return Qt::BottomDockWidgetArea;
	}

public slots:
	void onOpen(const QStringList& files, bool useOriginalTimestamp, const QString& namespacePrefix);
	void onStop();

protected:

	virtual QWidget* createPartControl();

	void setLastChannelsToPlay(boost::optional<std::vector<std::string>> v);
	boost::optional<std::vector<std::string>> getLastChannelsToPlay();

protected:

	bool mUseOriginalTimestamp;
	std::string mNamespacePrefix;
	std::vector<std::string> mLastTapes; 
	boost::optional<std::vector<std::string>> mLastChannelsToPlay;

	TapePlayerWidget* ui;
};

//////////////////////////////////////////////////////////////////////////////

}

#endif
