#!/bin/bash

# we need miracd from mirabash, so import that file
DIR=$(dirname "${BASH_SOURCE[0]}")
source $DIR/../mirabash

# exit on Ctrl+C
trap ctrl_c INT
function ctrl_c() {
	exit 2
}


function usage
{
	echo -e "\
Usage: mirasvn <command> [<package> [<package> ...]] [--auth] [options]\n\
Runs 'svn' for the specified packages or for all packages (if no package is specified).\n\n\
General Options:\n\
  --auth: request username and password just ONCE and use it for all calls to svn.\n\
\n\
Available commands:\n\
    changes     - shows the changes on the server that were made since the last update\n\
    status (st) - status of all branches that are listed in the index\n\
    update (up) - update to latest revision\n\
    commit (ci) - commit all changes (use with care!)\n\
\n\
    all other svn commands are supported too, type 'svn help' for a complete list"
}

function svnpackage
{
	miracd $1 &> /dev/null
	if [[ $? != 0 ]]; then
		echo -e "\e[01;31mPackage '$1' No such package found\e[00m"
	else
		echo -e "\e[01;32mPackage '$1' \e[00;32m[$PWD]\e[00m"
		svn $2 $3
	fi
}

if [[ $1 = "--help" ]] || [[ $# -lt 1 ]]; then
	usage
	exit 0
fi

# first param is the command
command="$1"

# other params may be packages, the others are the options for svn
# find the first parameter, that does contain a -, it will be the first option to 
# pass to svn
paramcount=$#
firstoption=$((${paramcount}+1))

for (( i=2; i<=${paramcount}; i++ ))
do
	if [[ ${!i} == -* ]]; then
		firstoption=$i
		break
	fi
done

auth=""
firstsvnoption=$firstoption
if [[ ${!firstoption} == "--auth" ]]; then
	read -p "Username: " username
	read -s -p "Password: " password
	echo ""
	firstsvnoption=$(($firstoption+1))
	auth="--username $username --password $password"
fi

svnoptions="${@:${firstsvnoption}}"

# handle additional commands
if [[ $command == "changes" ]]; then
	command="log -r BASE:HEAD"
fi

if [[ $firstoption == 2 ]]; then
	echo "Running 'svn $command $svnoptions' for all packages ..."
	echo "Reindexing packages ..." 
	$_mirafindpkg --reindex
	allpackages=($(bash $_mirafindpkg | awk -- '{print $1}'))
	for package in "${allpackages[@]}"	
	do
		svnpackage $package "$command" "$svnoptions $auth"
	done
else 
	# for each given package
	echo "Running 'svn $command $svnoptions' ..."
	for (( i=2; i<${firstoption}; i++ ))
	do
		package="${!i}"
		svnpackage $package "$command" "$svnoptions $auth"
	done
fi

