###############################################################################
# NCurses
###############################################################################

IF(WIN32)
	# On Win32...

ELSE(WIN32)
	# we cannot rely on pkgconfig since the library is installed quite often
	# although pkgconfig fails
#	pkg_check_modules(NCURSES REQUIRED ncurses)
#	pkg_check_modules(NCURSES_MENU REQUIRED menu)
#	pkg_check_modules(NCURSES_PANEL REQUIRED panel)
#	pkg_check_modules(NCURSES_FORM REQUIRED form)

	# try to find form.h
	FIND_FILE(FORMHEADER_PATH NAMES form.h)
	IF ("${FORMHEADER_PATH}" STREQUAL "FORMHEADER_PATH-NOTFOUND")
	    FIND_FILE(FORMHEADER_PATH NAMES ncurses/form.h)
	ENDIF()

	IF (NOT "${FORMHEADER_PATH}" STREQUAL "FORMHEADER_PATH-NOTFOUND")
		STRING(REPLACE "/form.h" "" "NCURSES_INCLUDE_DIRS" "${FORMHEADER_PATH}")
	ENDIF()
ENDIF(WIN32)

###############################################################################

IF (CMAKE_VERBOSE_MAKEFILE)
	MESSAGE(STATUS "NCURSES")
	MESSAGE(STATUS "   incdir = " ${NCURSES_INCLUDE_DIRS})
ENDIF (CMAKE_VERBOSE_MAKEFILE)
