###############################################################################
# Copyright (C) 2012 by
#   MetraLabs GmbH (MLAB), GERMANY
# and
#   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
# All rights reserved.
#
# Contact: info@mira-project.org
#
# Commercial Usage:
#   Licensees holding valid commercial licenses may use this file in
#   accordance with the commercial license agreement provided with the
#   software or, alternatively, in accordance with the terms contained in
#   a written agreement between you and MLAB or NICR.
#
# GNU General Public License Usage:
#   Alternatively, this file may be used under the terms of the GNU
#   General Public License version 3.0 as published by the Free Software
#   Foundation and appearing in the file LICENSE.GPL3 included in the
#   packaging of this file. Please review the following information to
#   ensure the GNU General Public License version 3.0 requirements will be
#   met: http://www.gnu.org/copyleft/gpl.html.
#   Alternatively you may (at your option) use any later version of the GNU
#   General Public License if such license has been publicly approved by
#   MLAB and NICR (or its successors, if any).
#
# IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
# INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
# THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
# "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
# BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
# FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
# ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
# PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
#
###############################################################################
#
# Provides ADD_PRECOMPILED_HEADER macro for supporting precompiled header.
#
# author: Erik Einhorn
#
# Parts of the follwing macro are taken from Rosegarden CMake-Files:
#      http://www.mail-archive.com/cmake@cmake.org/msg04394.html
#
###############################################################################

# turns _header into an absolut path (if not already) and stores it in _absheader
macro(MIRA_GET_ABSOLUTE_HEADER _header _absheader)
	if(IS_ABSOLUTE ${_header})
		set(${_absheader} ${_header})
	else()
		set(${_absheader} "${CMAKE_CURRENT_SOURCE_DIR}/${_header}")
	endif()
endmacro()

# generates a source file that is needed for generating the precompiled header
# on windows and adds the source file to the list of sources in _sources which
# must be passed to ADD_LIBRARY etc. (does nothing on linux)
macro(MIRA_PREPARE_PRECOMPILED_HEADER _target _header _sources)
	if(WIN32)
		set(_pchsource "${CMAKE_CURRENT_BINARY_DIR}/${_target}_pch.cpp")
		MIRA_GET_ABSOLUTE_HEADER(${_header}  header)
		configure_file(${MIRA_ROOT_DIR}/make/Pch.template ${_pchsource})
		list(INSERT ${_sources} 0  ${_pchsource})
	endif()
endmacro()

# adds precompiled header support to the specified _target, the specified _header 
# will be used to create a precompiled header that will be included by every 
# source file that is used to build the target.
macro(MIRA_ADD_PRECOMPILED_HEADER _target _header )

	get_filename_component(_name ${_header} NAME)
	get_filename_component(_namewe ${_header} NAME_WE)
	set(_pchdir "${CMAKE_CURRENT_BINARY_DIR}/CMakeFiles/${_target}.dir")
if(WIN32)
	set(_pcheader "${_pchdir}/${_namewe}.pch")
else()
	set(_pcheader "${_pchdir}/${_name}.gch")
endif()

	set(_headerInPch "${_pchdir}/${_name}")

	MIRA_GET_ABSOLUTE_HEADER(${_header} _absheader)

	#message(${_absheader})
	#message(${_pcheader})
	#message(${_headerInPch})

if(WIN32)

	get_target_property(_targetsources ${_target} SOURCES)

	list(GET _targetsources 0 _firstsource)
	list(REMOVE_AT _targetsources 0)

	set_source_files_properties(${_firstsource}
				PROPERTIES	
				COMPILE_FLAGS "/Yc${_absheader} /FI${_absheader} /Fp${_pcheader}"
				OBJECT_DEPENDS ${_absheader}
				OBJECT_OUTPUTS ${_pcheader}
	)

	foreach(item ${_targetsources})
		set_source_files_properties(${item} 
				PROPERTIES	
				COMPILE_FLAGS "/Yu${_absheader} /FI${_absheader} /Fp${_pcheader}"
				OBJECT_DEPENDS ${_pcheader}
		)
	endforeach(item)

else(WIN32)

	# assemble all compiler flags consisting of our "normal" cflags ...
	string(TOUPPER "CMAKE_CXX_FLAGS_${CMAKE_BUILD_TYPE}" _flags_var_name)
	set(_compiler_FLAGS "${${_flags_var_name}}")

	# ... and the input directories
	get_directory_property(_directory_flags INCLUDE_DIRECTORIES)
	foreach(item ${_directory_flags})
		list(APPEND _compiler_FLAGS "-I${item}")
	endforeach(item)

	get_directory_property(_directory_flags DEFINITIONS)
	list(APPEND _compiler_FLAGS ${_directory_flags})

	get_target_property(_definesymbol ${_target} DEFINE_SYMBOL)
	if(${_definesymbol} STREQUAL "_definesymbol-NOTFOUND")
	else()
		list(APPEND _compiler_FLAGS "-D${_definesymbol}")
	endif()

	# add fPIC flag, if we are compiling a library
	get_target_property(_targettype ${_target} TYPE)
	if( ${_targettype} STREQUAL "SHARED_LIBRARY")
		list(APPEND _compiler_FLAGS "-fPIC")
	endif()

	separate_arguments(_compiler_FLAGS)
	#message("FLAGS: " ${_compiler_FLAGS})

	# for debugging
	#message("${CMAKE_CXX_COMPILER} ${_compiler_FLAGS}  -x c++-header -o ${_pcheader} ${_absheader}")

	add_custom_command(OUTPUT ${_pcheader}
	                   COMMAND ${CMAKE_CXX_COMPILER}
	                            ${_compiler_FLAGS}
	                            -x c++-header
	                            -o ${_pcheader} ${_absheader}
	                   DEPENDS ${_absheader}
	                   IMPLICIT_DEPENDS CXX  ${_absheader}
	                   COMMENT "Generating precompiled header: ${_pcheader}")
	add_custom_target(${_target}_pch DEPENDS ${_pcheader})

	add_dependencies(${_target} ${_target}_pch)

	# add dependencies of all source files to the precompiled header
	get_target_property(_targetsources ${_target} SOURCES)
	set_source_files_properties(${_targetsources} PROPERTIES OBJECT_DEPENDS ${_pcheader})

	get_target_property(property ${_target} COMPILE_FLAGS)
	# Since the COMPILE_FLAGS might be an empty string, we have to use quoations marks!
	if("${property}" STREQUAL "property-NOTFOUND")
		SET_TARGET_PROPERTIES(${_target} PROPERTIES  COMPILE_FLAGS "-include ${_headerInPch} -Winvalid-pch" )
	else()
		SET_TARGET_PROPERTIES(${_target} PROPERTIES  COMPILE_FLAGS "-include ${_headerInPch} -Winvalid-pch ${property}" )
	endif()

endif(WIN32)

endmacro(MIRA_ADD_PRECOMPILED_HEADER)
