/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file SplashScreen.h
 *    Declaration of SplashScreen.
 *
 * @author Erik Einhorn
 * @date   2011/09/27
 */

#ifndef _MIRA_SPLASHSCREEN_H_
#define _MIRA_SPLASHSCREEN_H_

#include <QFrame>

#include <widgets/GuiWidgetsExports.h>

class QTimer;

namespace mira {

///////////////////////////////////////////////////////////////////////////////

/**
 * Widget provides a splash screen that can be shown during application startup.
 * Similar to QSplashScreen, but supports transparent pixmaps.
 * For a documentation of the methods, see QSplashScreen.
 */
class MIRA_GUI_WIDGETS_EXPORT SplashScreen : public QFrame
{
public:
	enum SpecialMode {
		DUMMY
	};

	/// Creates a disabled dummy SplashScreen, which does nothing
	SplashScreen(SpecialMode mode);

	SplashScreen(QWidget* parent, const QPixmap& pixmap);

public:

	/**
	 * Shows the splash screen.
	 */
	void show();

public:

	/**
	 * After calling this method the splash screen will hide automatically after
	 * the specified timeout has elapsed.
	 */
	void closeTimer(int timeout);

	/**
	 * After this method is called, the user can close the splash screen
	 * by clicking on it. (e.g. after startup is finished)
	 */
	void closeOnClick();

public:
	void clearMessage();
	void showMessage(const QString& message,
	                 int alignment = Qt::AlignLeft | Qt::AlignTop,
	                 const QColor& color = Qt::black);

	void setTextRect(const QRect& rect);

protected:

	virtual void mousePressEvent(QMouseEvent* event);

private:
	virtual void paintEvent(QPaintEvent* pe);

private:
	QPixmap mPixmap;
	QString mMessage;
	int mAlignment;
	QColor mColor;
	QRect mTextRect;

	QTimer*  mTimer;
	bool mCloseOnClick;

	bool mDummy;
};

///////////////////////////////////////////////////////////////////////////////

}

#endif
