/*
 * BenchmarkPublisher.C
 *
 *  Created on: 11.07.2012
 *      Author: erik
 */

#include <MOOSLIB/MOOSApp.h>

#include "../BenchmarkStats.h"
#include <algorithm>
#include <sstream>

class Publisher : public CMOOSApp
{
public:
	Publisher() : b("Publisher")
	{
		SetCommsFreq(200);
	 	SetAppFreq(10);
	}
	virtual ~Publisher()
	{

	}

	int N;
	BenchmarkStats b;

protected:

    bool OnNewMail(MOOSMSG_LIST &NewMail)
    {

    }

    bool Iterate()
    {
    	static double f = 0.0f;
    	f+=0.1f;

    	std::string data;
    	data.resize(N*1024);
    	std::fill(data.begin(), data.end(), 'a');

    	uint64_t start = b.tic();

    	// stuff the start time into the string, waaah, passing data via
    	// strings really is terrible
    	std::stringstream ss;
    	ss << start;
    	std::string s = ss.str();
    	for(std::size_t i=0; i<s.size(); ++i)
    		data[i] = s[i];
    	data[s.size()] = ' ';

    	m_Comms.Notify("Benchmark",data,MOOSTime());
    	b.toc();
    }



};



int main(int argc ,char * argv[])
{
	if(argc<2) {
		std::cout << "Usage: BenchmarkPublisher Data_Size_In_KB" << std::endl;
		return -1;
	}

	//make an application
	Publisher publisher;
	publisher.N = atoi(argv[1]);

	//run forever pasing registration name and mission file parameters
	publisher.Run("Publisher", "dummy.moos"); //,sMissionFile);

	//probably will never get here..
	return 0;
}

