/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file RPCAlignmentTest.C
 *    Test case for testing memory alignment (needed by Eigen) in parameters and return values
 *
 * @author Erik Einhorn
 * @date   2012/08/29
 */

#include <serialization/JSONSerializer.h>
#include <serialization/Print.h>
#include <serialization/adapters/std/vector>
#include <rpc/RPCManager.h>

#include <utils/Hexdump.h>

#include <transform/Pose.h>
#include <serialization/adapters/boost/tuple.hpp>

#include <boost/test/unit_test.hpp>
#include <boost/function.hpp>
#include <boost/bind.hpp>

/////////////////////////////////////////////////////////////////////////////////
using namespace mira;
using namespace std;


struct blabla {
	char dummy;
	Pose3 p;
	template<typename Reflector>
	void reflect(Reflector& r)
	{
		r.member("dummy",dummy,"");
		r.member("p",p,"");
	}
};


//typedef boost::tuple<Pose3,bool> Foo;
typedef Pose3 Foo;

class Service
{
public:

	template<typename Reflector>
	void reflect(Reflector& r)
	{
		r.method("method1", &Service::method1, this, "");
		r.method("method2", &Service::method2, this, "");
	}

	void method1(const Foo& p)
	{
		std::cout << "Service::method1 enter " << std::endl;
		std::cout << "Service::method1 " << print(p) << std::endl;
		//return p;
	}

	blabla method2(blabla p)
	{
		std::cout << "Service::method2 " << print(p) << std::endl;
		p.p.x()=1.0f;
		p.p.y()=2.0f;
		p.p.z()=3.0f;
		std::cout << &p << ", " << sizeof(p) << std::endl;
		std::cout << &(p.p) << ", " << sizeof(p.p) << std::endl;
		return p;
	}

};


void test1(Pose3 p)
{
	std::cout << "test1 enter " << std::endl;
	std::cout << "test1 " << print(p) << std::endl;
}

void test2(const Pose3& p)
{
	std::cout << "test2 enter " << std::endl;
	std::cout << "test2 " << print(p) << std::endl;
}


///////////////////////////////////////////////////////////////////////////////

class FinishHandler : public DeferredInvokerFinishHandler
{
public:
	virtual void onRPCfinished(const std::string& callId)
	{
		std::cout << "FinishHandler::onRPCfinished: " << callId << std::endl;
	}
};

class RPCHandler : public AbstractRPCHandler
{
public:

	RPCHandler()
	{
		thread = boost::thread(&RPCHandler::process, this);
	}

	virtual ~RPCHandler()
	{
		thread.interrupt();
		thread.join();
	}

	virtual void queueRequest(AbstractDeferredInvokerPtr invoker)
	{
		queue.push(invoker);
	}

	virtual boost::thread::id getThreadID() const
	{
		return thread.get_id();
	}

	void process()
	{
		while(!boost::this_thread::interruption_requested())
		{
			boost::mutex::scoped_lock lock(queueMutex);
			if(!queue.empty())
			{
				AbstractDeferredInvokerPtr invoker = queue.front();
				queue.pop();
				lock.unlock();

				invoker->invoke();

			} else
				lock.unlock();
			boost::this_thread::sleep(Duration::milliseconds(100));
		}
	}

	boost::mutex queueMutex;
	std::queue<AbstractDeferredInvokerPtr> queue;

	boost::thread thread;

};



BOOST_AUTO_TEST_CASE(FullTest)
{
#if 0
	blabla a;
	RPCManager mgr;

	AbstractRPCHandlerPtr handler(new RPCHandler);
	Service service;

	std::cout << "<<<<<<<<<<<<<< Local tests <<<<<<<<<<<<<<<<<<<<<<<" << std::endl;
	mgr.addLocalService("Service", service, handler);

	std::cout << "Local services: " << std::endl;
	const std::set<std::string>& sl = mgr.getLocalServices();
	foreach(const std::string& v, sl)
		std::cout << "  " << v << std::endl;

	BOOST_CHECK_EQUAL(mgr.existsService("Service"), true);

	//RPCFuture<Foo> res1 = mgr.call<Foo>("Service", "method1", boost::make_tuple(false,Pose3()));
	//RPCFuture<Foo> res1 = mgr.call<Foo>("Service", "method1", Pose3());
	//RPCFuture<void> res1 = mgr.call<void>("Service", "method1", Pose3());
	//res1.get();
	//RPCFuture<Foo> res1 = mgr.call<Foo>("Service", "method1");
	//std::cout << "Result: " << print(res1.get()) << std::endl;

	Pose3 p;
	std::cout << "Result: " << print(p) << std::endl;
	test1(p);
	test2(p);

	boost::function<void()> test3 = boost::bind(test1,p);
	test3();

/*
	RPCFuture<blabla> res2 = mgr.call<blabla>("Service", "method2", blabla());
	std::cout << "Result: " << print(res2.get()) << std::endl;
*/
	boost::this_thread::sleep(Duration::milliseconds(1000));

#endif
}

