/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file EigenFormat.C
 *    Example for reading and writing eigen matrices in
 *    human-readable format using different styles (Matlab, etc.)
 *    from and to streams.
 *
 * @author Erik Einhorn
 * @date   31.08.2010
 */

#include <iostream>
#include <sstream>

#include <math/EigenFormat.h>

using namespace std;
using namespace Eigen;
using namespace mira;

int main()
{
	Matrix4f m;
	m << 1,2,3,4,
		 5,6,7,8,
		 9,10,11,12,
		 13,14,15,16;

	//////////////////////
	// Matrix output:
	cout << endl << "Matrix output in different styles: " << endl << endl;

	cout << "Matlab style: " << endl;
	cout << format(m) << endl << endl;

	cout << "Eigen style: " << endl;
	cout << format(m, EigenFormat::eigen()) << endl << endl;

	cout << "Clean style: " << endl;
	cout << format(m, EigenFormat::clean()) << endl << endl;

	cout << "numpy style: " << endl;
	cout << format(m, EigenFormat::python()) << endl << endl;

	//////////////////////
	// Matrix input:
	string s = "[2,4,6,8;10, 12,  14,16 ; 18,20,22,24 ;26,28,30,32 ]";
	cout << "Reading string: '" << s << "' into matrix" << endl;

	stringstream ss(s);

	// read matrix from stream in matlab style
	ss >> format(m);

	cout << "Result is: " << endl << format(m) << endl << endl;
	return 0;
}

