/*
 * Decompiled with CFR 0.152.
 */
package peak.can.basic;

public enum TPCANParameterValue {
    PCAN_PARAMETER_OFF(0),
    PCAN_PARAMETER_ON(1),
    PCAN_FILTER_CLOSE(0),
    PCAN_FILTER_OPEN(1),
    PCAN_FILTER_CUSTOM(2),
    PCAN_CHANNEL_UNAVAILABLE(0),
    PCAN_CHANNEL_AVAILABLE(1),
    PCAN_CHANNEL_OCCUPIED(2),
    PCAN_CHANNEL_PCANVIEW(TPCANParameterValue.PCAN_CHANNEL_AVAILABLE.value | TPCANParameterValue.PCAN_CHANNEL_OCCUPIED.value),
    LOG_FUNCTION_DEFAULT(0),
    LOG_FUNCTION_ENTRY(1),
    LOG_FUNCTION_PARAMETERS(2),
    LOG_FUNCTION_LEAVE(4),
    LOG_FUNCTION_WRITE(8),
    LOG_FUNCTION_READ(16),
    LOG_FUNCTION_ALL(65535),
    TRACE_FILE_SINGLE(0),
    TRACE_FILE_SEGMENTED(1),
    TRACE_FILE_DATE(2),
    TRACE_FILE_TIME(4),
    TRACE_FILE_OVERWRITE(128),
    FEATURE_FD_CAPABLE(1);

    private final int value;

    private TPCANParameterValue(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static TPCANParameterValue parseOnOff(int value) {
        if (value == PCAN_PARAMETER_ON.getValue()) {
            return PCAN_PARAMETER_ON;
        }
        if (value == PCAN_PARAMETER_OFF.getValue()) {
            return PCAN_PARAMETER_OFF;
        }
        return null;
    }

    public static TPCANParameterValue parseCondition(int value) {
        if (value == PCAN_CHANNEL_AVAILABLE.getValue()) {
            return PCAN_CHANNEL_AVAILABLE;
        }
        if (value == PCAN_CHANNEL_UNAVAILABLE.getValue()) {
            return PCAN_CHANNEL_UNAVAILABLE;
        }
        if (value == PCAN_CHANNEL_OCCUPIED.getValue()) {
            return PCAN_CHANNEL_OCCUPIED;
        }
        if (value == PCAN_CHANNEL_PCANVIEW.getValue()) {
            return PCAN_CHANNEL_PCANVIEW;
        }
        return null;
    }

    public static TPCANParameterValue parseFilterStatus(int value) {
        if (value == PCAN_FILTER_CLOSE.getValue()) {
            return PCAN_FILTER_CLOSE;
        }
        if (value == PCAN_FILTER_OPEN.getValue()) {
            return PCAN_FILTER_OPEN;
        }
        if (value == PCAN_FILTER_CUSTOM.getValue()) {
            return PCAN_FILTER_CUSTOM;
        }
        return null;
    }
}

