/*
 * Decompiled with CFR 0.152.
 */
package peak.can;

import peak.can.basic.TPCANMessageType;
import peak.can.basic.TPCANMsg;
import peak.can.basic.TPCANMsgFD;
import peak.can.basic.TPCANTimestamp;
import peak.can.basic.TPCANTimestampFD;

public class TableDataRow {
    private TPCANTimestamp rcvTime;
    private TPCANTimestampFD rcvTimeFd;
    private int counter;
    private TPCANMsg message;
    private TPCANMsgFD messageFd;

    public int getCounter() {
        return this.counter;
    }

    public void setCounter(int counter) {
        this.counter = counter;
    }

    public void setMessage(TPCANMsg message) {
        this.message = message;
    }

    public void setMessage(TPCANMsgFD messageFd) {
        this.messageFd = messageFd;
    }

    public void setRcvTime(TPCANTimestamp rcvTime) {
        this.rcvTime = rcvTime;
    }

    public void setRcvTime(TPCANTimestampFD rcvTimeFd) {
        this.rcvTimeFd = rcvTimeFd;
    }

    public String getMsgType() {
        String result = "";
        if (this.message != null) {
            result = this.message.getType() == TPCANMessageType.PCAN_MESSAGE_STANDARD.getValue() ? "Standard" : (this.message.getType() == TPCANMessageType.PCAN_MESSAGE_EXTENDED.getValue() ? "Extended" : Byte.toString(this.message.getType()));
        } else if (this.messageFd != null) {
            result = this.messageFd.getTypeEnum().contains((Object)TPCANMessageType.PCAN_MESSAGE_STATUS) ? "Status" : (this.messageFd.getTypeEnum().contains((Object)TPCANMessageType.PCAN_MESSAGE_STANDARD) ? "Standard" : (this.messageFd.getTypeEnum().contains((Object)TPCANMessageType.PCAN_MESSAGE_EXTENDED) ? "Extended" : Byte.toString(this.messageFd.getType())));
            if (this.messageFd.getTypeEnum().contains((Object)TPCANMessageType.PCAN_MESSAGE_FD)) {
                result = result + " (FD)";
            }
        }
        return result;
    }

    public int getMsgLength() {
        if (this.message != null) {
            return this.message.getLength();
        }
        if (this.messageFd != null) {
            return this.messageFd.getLengthFromDLC();
        }
        return 0;
    }

    public int getMsgId() {
        if (this.message != null) {
            return this.message.getID();
        }
        if (this.messageFd != null) {
            return this.messageFd.getID();
        }
        return 0;
    }

    public byte[] getMsgData() {
        if (this.message != null) {
            return this.message.getData();
        }
        if (this.messageFd != null) {
            return this.messageFd.getData();
        }
        return null;
    }

    public String getRcvTimeAsString() {
        if (this.rcvTime != null) {
            return String.valueOf(this.rcvTime.getMillis()) + "." + String.valueOf(this.rcvTime.getMicros());
        }
        if (this.rcvTimeFd != null) {
            return String.valueOf(this.rcvTimeFd.getValue());
        }
        return null;
    }
}

