/*
 * Decompiled with CFR 0.152.
 */
package peak.can;

import java.util.HashMap;
import java.util.Vector;
import peak.can.Application;
import peak.can.ChannelItem;
import peak.can.MarkAllChannelItem;
import peak.can.TableDataRow;
import peak.can.basic.IRcvEventProcessor;
import peak.can.basic.PCANBasic;
import peak.can.basic.TPCANHandle;
import peak.can.basic.TPCANMsg;
import peak.can.basic.TPCANMsgFD;
import peak.can.basic.TPCANStatus;
import peak.can.basic.TPCANTimestamp;
import peak.can.basic.TPCANTimestampFD;

public class CANReadThread
extends Thread
implements IRcvEventProcessor {
    private PCANBasic pcanBasic;
    private Vector<ChannelItem> connectedChannelCollection = null;
    private HashMap dataRowCollection;
    private Boolean readTimeStamp = false;

    public Boolean getReadTimeStamp() {
        return this.readTimeStamp;
    }

    public void setReadTimeStamp(Boolean useReadEx) {
        this.readTimeStamp = useReadEx;
    }

    public CANReadThread(PCANBasic pcanbasic, Vector<ChannelItem> connectedChannelCollection, HashMap dataRowCollection) {
        this.pcanBasic = pcanbasic;
        this.dataRowCollection = dataRowCollection;
        this.connectedChannelCollection = connectedChannelCollection;
    }

    @Override
    public void run() {
        while (true) {
            for (ChannelItem item : this.connectedChannelCollection) {
                if (item == MarkAllChannelItem.getInstance() || !item.getWorking()) continue;
                if (item.isCanFd()) {
                    this.callAPIFunctionReadFd(item.getHandle());
                    continue;
                }
                this.callAPIFunctionRead(item.getHandle());
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void callAPIFunctionRead(TPCANHandle handle) {
        TPCANMsg canMessage = null;
        TPCANTimestamp rcvTime = null;
        TableDataRow dataRow = null;
        int messageID = 0;
        try {
            TPCANStatus ret;
            canMessage = new TPCANMsg();
            rcvTime = new TPCANTimestamp();
            do {
                if ((ret = this.readTimeStamp != false ? this.pcanBasic.Read(handle, canMessage, rcvTime) : this.pcanBasic.Read(handle, canMessage, null)) != TPCANStatus.PCAN_ERROR_OK) continue;
                messageID = canMessage.getID();
                dataRow = this.dataRowCollection.containsKey(messageID) ? (TableDataRow)this.dataRowCollection.get(messageID) : new TableDataRow();
                dataRow.setMessage(canMessage);
                if (this.readTimeStamp.booleanValue()) {
                    dataRow.setRcvTime(rcvTime);
                } else {
                    dataRow.setRcvTime((TPCANTimestamp)null);
                }
                dataRow.setCounter(dataRow.getCounter() + 1);
                Object object = Application.token;
                synchronized (object) {
                    this.dataRowCollection.put(messageID, dataRow);
                }
            } while (ret != TPCANStatus.PCAN_ERROR_QRCVEMPTY || ret == TPCANStatus.PCAN_ERROR_OK);
            canMessage = null;
            rcvTime = null;
        }
        catch (Exception e) {
            System.out.println("CANReadThread Exception:" + e.getMessage());
            e.printStackTrace();
            System.exit(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void callAPIFunctionReadFd(TPCANHandle handle) {
        TPCANMsgFD canMessage = null;
        TPCANTimestampFD rcvTime = null;
        TableDataRow dataRow = null;
        int messageID = 0;
        try {
            TPCANStatus ret;
            canMessage = new TPCANMsgFD();
            rcvTime = new TPCANTimestampFD();
            do {
                if ((ret = this.readTimeStamp != false ? this.pcanBasic.ReadFD(handle, canMessage, rcvTime) : this.pcanBasic.ReadFD(handle, canMessage, null)) != TPCANStatus.PCAN_ERROR_OK) continue;
                messageID = canMessage.getID();
                dataRow = this.dataRowCollection.containsKey(messageID) ? (TableDataRow)this.dataRowCollection.get(messageID) : new TableDataRow();
                dataRow.setMessage(canMessage);
                if (this.readTimeStamp.booleanValue()) {
                    dataRow.setRcvTime(rcvTime);
                } else {
                    dataRow.setRcvTime((TPCANTimestampFD)null);
                }
                dataRow.setCounter(dataRow.getCounter() + 1);
                Object object = Application.token;
                synchronized (object) {
                    this.dataRowCollection.put(messageID, dataRow);
                }
            } while (ret != TPCANStatus.PCAN_ERROR_QRCVEMPTY || ret == TPCANStatus.PCAN_ERROR_OK);
            canMessage = null;
            rcvTime = null;
        }
        catch (Exception e) {
            System.out.println("CANReadThread Exception:" + e.getMessage());
            e.printStackTrace();
            System.exit(0);
        }
    }

    @Override
    public void processRcvEvent(TPCANHandle channel) {
        for (ChannelItem item : this.connectedChannelCollection) {
            if (item.getHandle() != channel) continue;
            if (item.isCanFd()) {
                this.callAPIFunctionReadFd(channel);
            } else {
                this.callAPIFunctionRead(channel);
            }
            return;
        }
    }
}

