/*
 * Decompiled with CFR 0.152.
 */
package peak.can.basic;

import java.util.ArrayDeque;

public enum TPCANParameter {
    PCAN_DEVICE_NUMBER(1),
    PCAN_5VOLTS_POWER(2),
    PCAN_RECEIVE_EVENT(3),
    PCAN_MESSAGE_FILTER(4),
    PCAN_API_VERSION(5),
    PCAN_CHANNEL_VERSION(6),
    PCAN_BUSOFF_AUTORESET(7),
    PCAN_LISTEN_ONLY(8),
    PCAN_LOG_LOCATION(9),
    PCAN_LOG_STATUS(10),
    PCAN_LOG_CONFIGURE(11),
    PCAN_LOG_TEXT(12),
    PCAN_CHANNEL_CONDITION(13),
    PCAN_HARDWARE_NAME(14),
    PCAN_RECEIVE_STATUS(15),
    PCAN_CONTROLLER_NUMBER(16),
    PCAN_TRACE_LOCATION(17),
    PCAN_TRACE_STATUS(18),
    PCAN_TRACE_SIZE(19),
    PCAN_TRACE_CONFIGURE(20),
    PCAN_CHANNEL_IDENTIFYING(21),
    PCAN_CHANNEL_FEATURES(22),
    PCAN_BITRATE_ADAPTING(23),
    PCAN_BITRATE_INFO(24),
    PCAN_BITRATE_INFO_FD(25),
    PCAN_BUSSPEED_NOMINAL(26),
    PCAN_BUSSPEED_DATA(27),
    PCAN_IP_ADDRESS(28);

    private final int value;

    private TPCANParameter(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static Object[] customizableParameters() {
        ArrayDeque<TPCANParameter> result = new ArrayDeque<TPCANParameter>();
        result.add(PCAN_DEVICE_NUMBER);
        result.add(PCAN_5VOLTS_POWER);
        result.add(PCAN_API_VERSION);
        result.add(PCAN_CHANNEL_VERSION);
        result.add(PCAN_BUSOFF_AUTORESET);
        result.add(PCAN_LISTEN_ONLY);
        result.add(PCAN_LOG_LOCATION);
        result.add(PCAN_LOG_STATUS);
        result.add(PCAN_LOG_CONFIGURE);
        result.add(PCAN_CHANNEL_CONDITION);
        result.add(PCAN_HARDWARE_NAME);
        result.add(PCAN_RECEIVE_STATUS);
        result.add(PCAN_CONTROLLER_NUMBER);
        result.add(PCAN_TRACE_LOCATION);
        result.add(PCAN_TRACE_STATUS);
        result.add(PCAN_TRACE_SIZE);
        result.add(PCAN_TRACE_CONFIGURE);
        result.add(PCAN_CHANNEL_IDENTIFYING);
        result.add(PCAN_CHANNEL_FEATURES);
        result.add(PCAN_BITRATE_ADAPTING);
        result.add(PCAN_BITRATE_INFO);
        result.add(PCAN_BITRATE_INFO_FD);
        result.add(PCAN_BUSSPEED_NOMINAL);
        result.add(PCAN_BUSSPEED_DATA);
        result.add(PCAN_IP_ADDRESS);
        return result.toArray();
    }

    public static String getParameterDescription(TPCANParameter param) {
        String description = "";
        switch (param) {
            case PCAN_DEVICE_NUMBER: {
                description = "This parameter is used on PCAN-USB hardware to distinguish between 2 (or more) of them on the same computer. This value is persistent, i.e. the identifier will not be lost after disconnecting and connecting again the hardware.";
                break;
            }
            case PCAN_5VOLTS_POWER: {
                description = "This parameter is used on PCAN-PC Card hardware for switching the external 5V on the D-Sub connector of the PC Card. This is useful when connecting external bus converter modules to the card (AU5790 / TJA1954)).";
                break;
            }
            case PCAN_API_VERSION: {
                description = "This parameter is used to get information about the PCAN-Basic API implementation version.";
                break;
            }
            case PCAN_CHANNEL_VERSION: {
                description = "This parameter is used to get version information about the Driver of a PCAN Channel.";
                break;
            }
            case PCAN_BUSOFF_AUTORESET: {
                description = "This parameter instructs the PCAN driver to reset automatically the CAN controller of a PCAN channel when a bus-off state is detected. Since no communication is possible on a bus-off state, it is useful to let the driver to catch this event automatically and reset the controller, avoiding extra handling of this problem in an end application.";
                break;
            }
            case PCAN_LISTEN_ONLY: {
                description = "This parameter allows the user to set a CAN hardware in Listen-Only mode. When this mode is set, the CAN controller doens't take part on active events (eg. transmit CAN messages) but stays in a passive mode (CAN monitor), in which it can analyse the traffic on the CAN bus used by a PCAN channel. See also the Philips Data Sheet \"SJA1000 Stand-alone CAN controller\".";
                break;
            }
            case PCAN_LOG_LOCATION: {
                description = "This value is used to set the folder location on a computer for the Log-File generated by the PCAN-Basic API, within a debug session. Setting this value starts recording debug information automatically. If a debug session is running (a log file is being written), PCAN_LOG_LOCATION instructs the API to close the current log file and to start the process again with the new folder information. Note that the name of the log file cannot be specified, this name is fixed as PCANBasic.log.";
                break;
            }
            case PCAN_LOG_STATUS: {
                description = "This value is used to control the activity status of a debug session within the PCAN-Basic API. If the log status is set to ON without having set a location for the log file or without having configured the information to be traced, then the session process will start with the default values.";
                break;
            }
            case PCAN_LOG_CONFIGURE: {
                description = "This value is used to configure the debug information to be included in the log file generated in a debug session within the PCAN-Basic API.";
                break;
            }
            case PCAN_CHANNEL_CONDITION: {
                description = "This parameter is used to check and detect available PCAN hardware on a computer, even before trying to connect any of them. This is useful when an application wants the user to select which hardware should be using in a communication session.";
                break;
            }
            case PCAN_HARDWARE_NAME: {
                description = "This parameter is to read the Name of the Hardware.";
                break;
            }
            case PCAN_RECEIVE_STATUS: {
                description = "This Parameter is to get the reception status of a PCAN-Channel.";
                break;
            }
            case PCAN_CONTROLLER_NUMBER: {
                description = "This Parameter is to get CAN-Controller number of a PCAN-Channel. Only usefull with 2 Channel HW.";
                break;
            }
            case PCAN_TRACE_LOCATION: {
                description = "This Parameter is used to configure the Trace File Directory.";
                break;
            }
            case PCAN_TRACE_STATUS: {
                description = "This Parameter is used to control the activity of the Tracer status.";
                break;
            }
            case PCAN_TRACE_SIZE: {
                description = "This Parameter is used to configure the maximum file size of a CAN trace.";
                break;
            }
            case PCAN_TRACE_CONFIGURE: {
                description = "This Parameter is used to configure the trace file storing mode (TRACE_FILE_***).";
                break;
            }
            case PCAN_CHANNEL_IDENTIFYING: {
                description = "This Parameter is used to Physically identify a USB based PCAN-Channel by blinking its associated LED.";
                break;
            }
            case PCAN_CHANNEL_FEATURES: {
                description = "This Parameter is used to get the capabilities of a PCAN device.";
                break;
            }
            case PCAN_BITRATE_ADAPTING: {
                description = "This Parameter is used to force an initialization process to succeed, even if the PCAN-Channel is being used by a PCAN-View with a different or unknown bit rate.";
                break;
            }
            case PCAN_BITRATE_INFO: {
                description = "This Parameter is used to read the currently configured communication speed of a PCAN Channel connected as standard CAN.";
                break;
            }
            case PCAN_BITRATE_INFO_FD: {
                description = "This Parameter is used to read the currently configured communication speed, as a parameterized string value (FD Bit rate String), of a PCAN Channel connected as CAN FD.";
                break;
            }
            case PCAN_BUSSPEED_NOMINAL: {
                description = "This Parameter is used to read the configured nominal CAN Bus speed as Bits per seconds.";
                break;
            }
            case PCAN_BUSSPEED_DATA: {
                description = "This Parameter is used to read configured CAN data speed as Bits per seconds.";
                break;
            }
            case PCAN_IP_ADDRESS: {
                description = "This Parameter is used to read the remote address of a LAN channel as string in IPv4 format.";
            }
        }
        return description;
    }
}

