/*
 * Decompiled with CFR 0.152.
 */
package peak.can;

import java.util.EnumSet;
import java.util.Random;
import java.util.Vector;
import peak.can.Application;
import peak.can.ChannelItem;
import peak.can.MarkAllChannelItem;
import peak.can.basic.PCANBasic;
import peak.can.basic.TPCANHandle;
import peak.can.basic.TPCANMessageType;
import peak.can.basic.TPCANMsg;
import peak.can.basic.TPCANMsgFD;
import peak.can.basic.TPCANStatus;

public class CANSendThread
extends Thread {
    private PCANBasic pcanBasic;
    private Vector<ChannelItem> connectedChannelCollection = null;
    private int SendInterval;
    private TPCANMsg canMessage = null;
    private TPCANMsgFD canMessageFd = null;
    private TPCANStatus ret;
    Random randomGenerator;

    public int getSendInterval() {
        return this.SendInterval;
    }

    public void setSendInterval(int interval) {
        this.SendInterval = interval;
    }

    public CANSendThread(PCANBasic pcanbasic, Vector<ChannelItem> connectedChannelCollection) {
        this.pcanBasic = pcanbasic;
        this.connectedChannelCollection = connectedChannelCollection;
        this.canMessage = new TPCANMsg();
        this.canMessage.setID(1024);
        this.canMessage.setLength((byte)8);
        this.canMessage.setType(TPCANMsg.MSGTYPE_STANDARD);
        this.randomGenerator = new Random();
        this.canMessageFd = new TPCANMsgFD();
        this.canMessageFd.setID(1024);
        this.canMessageFd.setDlc((byte)14);
        this.canMessageFd.setType(EnumSet.of(TPCANMessageType.PCAN_MESSAGE_STANDARD, TPCANMessageType.PCAN_MESSAGE_FD));
    }

    protected void finalize() throws Throwable {
        this.canMessage = null;
        this.randomGenerator = null;
    }

    @Override
    public void run() {
        while (true) {
            for (ChannelItem item : this.connectedChannelCollection) {
                if (item == MarkAllChannelItem.getInstance() || !item.getWorking()) continue;
                this.callAPIFunctionSend(item.getHandle(), item.isCanFd());
            }
            try {
                Thread.sleep(this.SendInterval);
            }
            catch (InterruptedException e) {
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void callAPIFunctionSend(TPCANHandle handle, boolean isCanFd) {
        block9: {
            try {
                int i;
                byte Data = (byte)this.randomGenerator.nextInt(249);
                if (!isCanFd) {
                    int length = this.canMessage.getLength();
                    Data = (byte)this.randomGenerator.nextInt(249);
                    for (i = 0; i < length; ++i) {
                        this.canMessage.getData()[i] = (byte)(Data + i);
                    }
                    this.ret = this.pcanBasic.Write(handle, this.canMessage);
                } else {
                    int length = this.canMessageFd.getLengthFromDLC();
                    for (i = 0; i < length; ++i) {
                        this.canMessageFd.getData()[i] = (byte)(Data + i);
                    }
                    this.ret = this.pcanBasic.WriteFD(handle, this.canMessageFd);
                }
                if (this.ret != TPCANStatus.PCAN_ERROR_OK) break block9;
                Object object = Application.token;
                synchronized (object) {
                }
            }
            catch (Exception e) {
                System.out.println("CANSendThread Exception:" + e.getMessage());
                e.printStackTrace();
                System.exit(0);
            }
        }
    }
}

